/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.tasks;

import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.diagnostics.AbstractProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Not worth caching")
public abstract class RunsReport
extends AbstractProjectBasedReportTask<RunsProjectReport> {
    private final Renderer renderer = new Renderer();

    protected ReportRenderer getRenderer() {
        return this.renderer;
    }

    protected void generateReportFor(@NotNull ProjectDetails project, @NotNull RunsProjectReport model) {
        model.getRuns().forEach(this.renderer::renderRun);
        this.renderer.completeProject(project);
    }

    @NotNull
    protected RunsProjectReport calculateReportModelFor(@NotNull Project project) {
        RunManager runs = (RunManager)project.getExtensions().getByType(RunManager.class);
        RunsProjectReport report = new RunsProjectReport();
        runs.stream().toList().forEach(run -> report.addRun(new RenderableRun((Run)run)));
        return report;
    }

    public static class Renderer
    extends TextReportRenderer {
        private boolean hasRuns = false;

        public void completeProject(ProjectDetails project) {
            super.completeProject(project);
            if (!this.hasRuns) {
                this.getTextOutput().text((Object)"  - No Runs");
            }
        }

        private void outputHeader(String header) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Header).text((Object)header);
            this.outputNewLine();
            this.outputNormal("----------------------------------------------------------");
        }

        private void outputIdentifier(String identifier) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)identifier);
        }

        private void outputNormal(String normal) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).text((Object)normal);
        }

        private void outputError(String error) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Error).text((Object)error);
        }

        private void outputNewLine() {
            this.getTextOutput().println();
        }

        private void renderRun(RenderableRun run) {
            if (this.hasRuns) {
                this.getTextOutput().println();
            }
            this.outputHeader("Run: " + run.getName());
            this.outputNewLine();
            this.outputIdentifier("Main Class:");
            this.outputNormal(run.getMainClass());
            this.outputNewLine();
            this.outputIdentifier("Should Build All Projects:");
            this.outputNewLine();
            this.outputIdentifier("Working Directory:");
            this.outputNormal(run.getWorkingDirectory());
            this.outputNewLine();
            this.outputIdentifier("Is Single Instance:");
            this.outputNormal(String.valueOf(run.isSingleInstance()));
            this.outputNewLine();
            this.outputIdentifier("Is Client:");
            this.outputNormal(String.valueOf(run.isClient()));
            this.outputNewLine();
            this.outputIdentifier("Is Server:");
            this.outputNormal(String.valueOf(run.isServer()));
            this.outputNewLine();
            this.outputIdentifier("Is Data Generator:");
            this.outputNormal(String.valueOf(run.isData()));
            this.outputNewLine();
            this.outputIdentifier("Is JUnit:");
            this.outputNormal(String.valueOf(run.isJUnit()));
            this.outputNewLine();
            this.outputIdentifier("Is Game Test:");
            this.outputNormal(String.valueOf(run.isGameTest()));
            this.outputNewLine();
            this.renderEnvironment(run.getEnvironment());
            this.renderProperties(run.getProperties());
            this.renderProgramArguments(run.getArguments());
            this.renderJvmArguments(run.getJvmArguments());
            this.renderModSources(run.getModSources());
            this.renderUnitTestSources(run.getUnitTestSources());
            this.renderClasspath(run.getClasspath());
            this.renderDependencies(run.getDependencies());
            this.outputNewLine();
            this.outputNewLine();
        }

        private void renderEnvironment(Map<String, String> environment) {
            this.outputIdentifier("Environment Variables:");
            this.outputNewLine();
            if (environment.isEmpty()) {
                this.outputNormal("  - No Environment Variables");
                this.outputNewLine();
            } else {
                environment.forEach((key, value) -> {
                    this.outputIdentifier("  - " + key + ":");
                    this.outputNormal((String)value);
                    this.outputNewLine();
                });
            }
        }

        private void renderProperties(Map<String, String> properties) {
            this.outputIdentifier("System Properties:");
            this.outputNewLine();
            if (properties.isEmpty()) {
                this.outputNormal("  - No System Properties");
                this.outputNewLine();
            } else {
                properties.forEach((key, value) -> {
                    this.outputIdentifier("  - " + key + ":");
                    this.outputNormal((String)value);
                    this.outputNewLine();
                });
            }
        }

        private void renderProgramArguments(List<String> programArguments) {
            this.outputIdentifier("Program Arguments:");
            this.outputNewLine();
            if (programArguments.isEmpty()) {
                this.outputNormal("  - No Program Arguments");
                this.outputNewLine();
            } else {
                programArguments.forEach(arg -> {
                    this.outputNormal("  - " + arg);
                    this.outputNewLine();
                });
            }
        }

        private void renderJvmArguments(List<String> jvmArguments) {
            this.outputIdentifier("JVM Arguments:");
            this.outputNewLine();
            if (jvmArguments.isEmpty()) {
                this.outputNormal("  - No JVM Arguments");
                this.outputNewLine();
            } else {
                jvmArguments.forEach(arg -> {
                    this.outputNormal("  - " + arg);
                    this.outputNewLine();
                });
            }
        }

        private void renderModSources(Multimap<String, SourceSet> modSources) {
            this.outputIdentifier("Mod Sources:");
            this.outputNewLine();
            if (modSources.isEmpty()) {
                this.outputError("  - No Mod Sources");
                this.outputNewLine();
            } else {
                modSources.keySet().forEach(projectId -> {
                    this.outputIdentifier("  - " + projectId + ":");
                    this.outputNewLine();
                    Collection sourceSets = modSources.get(projectId);
                    if (sourceSets.isEmpty()) {
                        this.outputNormal("    - No Source Sets");
                        this.outputNewLine();
                    } else {
                        sourceSets.forEach(sourceSet -> {
                            this.outputNormal("    - " + sourceSet.getName());
                            this.outputNewLine();
                        });
                    }
                });
            }
        }

        private void renderUnitTestSources(Multimap<String, SourceSet> unitTestSources) {
            this.outputIdentifier("Unit Test Sources:");
            this.outputNewLine();
            if (unitTestSources.isEmpty()) {
                this.outputError("  - No Unit Test Sources");
                this.outputNewLine();
            } else {
                unitTestSources.keySet().forEach(projectId -> {
                    this.outputIdentifier("  - " + projectId + ":");
                    this.outputNewLine();
                    Collection sourceSets = unitTestSources.get(projectId);
                    if (sourceSets.isEmpty()) {
                        this.outputNormal("    - No Source Sets");
                        this.outputNewLine();
                    } else {
                        sourceSets.forEach(sourceSet -> {
                            this.outputNormal("    - " + sourceSet.getName());
                            this.outputNewLine();
                        });
                    }
                });
            }
        }

        private void renderClasspath(Set<String> classpath) {
            this.outputIdentifier("Classpath:");
            this.outputNewLine();
            if (classpath.isEmpty()) {
                this.outputError("  - No Classpath entries");
                this.outputNewLine();
            } else {
                classpath.forEach(path -> {
                    this.outputNormal("  - " + path);
                    this.outputNewLine();
                });
            }
        }

        private void renderDependencies(Set<String> dependencies) {
            this.outputIdentifier("Dependencies:");
            this.outputNewLine();
            if (dependencies.isEmpty()) {
                this.outputError("  - No Dependencies");
                this.outputNewLine();
            } else {
                dependencies.forEach(dependency -> {
                    this.outputNormal("  - " + dependency);
                    this.outputNewLine();
                });
            }
        }
    }

    public static class RunsProjectReport {
        private final List<RenderableRun> runs = new ArrayList<RenderableRun>();

        public void addRun(RenderableRun run) {
            this.runs.add(run);
        }

        public List<RenderableRun> getRuns() {
            return this.runs;
        }
    }

    public static class RenderableRun {
        private final String name;
        private final Map<String, String> environment;
        private final String mainClass;
        private final Map<String, String> properties;
        private final List<String> arguments;
        private final List<String> jvmArguments;
        private final boolean isSingleInstance;
        private final String workingDirectory;
        private final boolean isClient;
        private final boolean isServer;
        private final boolean isData;
        private final boolean isJUnit;
        private final boolean isGameTest;
        private final Multimap<String, SourceSet> modSources;
        private final Multimap<String, SourceSet> unitTestSources;
        private final Set<String> classpath;
        private final Set<String> dependencies;

        public RenderableRun(Run run) {
            this.name = run.getName();
            this.environment = (Map)run.getEnvironmentVariables().get();
            this.mainClass = (String)run.getMainClass().get();
            this.properties = (Map)run.getSystemProperties().get();
            this.arguments = RunsUtil.deduplicateElementsFollowingEachOther(((List)run.getArguments().get()).stream()).toList();
            this.jvmArguments = RunsUtil.deduplicateElementsFollowingEachOther(((List)run.getJvmArguments().get()).stream()).toList();
            this.isSingleInstance = (Boolean)run.getIsSingleInstance().get();
            this.workingDirectory = ((Directory)run.getWorkingDirectory().get()).getAsFile().getAbsolutePath();
            this.isClient = (Boolean)run.getIsClient().get();
            this.isServer = (Boolean)run.getIsServer().get();
            this.isData = (Boolean)run.getIsDataGenerator().get();
            this.isJUnit = (Boolean)run.getIsJUnit().get();
            this.isGameTest = (Boolean)run.getIsGameTest().get();
            this.modSources = (Multimap)run.getModSources().all().get();
            this.unitTestSources = (Multimap)run.getUnitTestSources().all().get();
            this.classpath = run.getRuntimeClasspath().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toSet());
            this.dependencies = run.getDependencies().getRuntimeConfiguration().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toSet());
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public List<String> getArguments() {
            return this.arguments;
        }

        public List<String> getJvmArguments() {
            return this.jvmArguments;
        }

        public boolean isSingleInstance() {
            return this.isSingleInstance;
        }

        public String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public boolean isClient() {
            return this.isClient;
        }

        public boolean isServer() {
            return this.isServer;
        }

        public boolean isData() {
            return this.isData;
        }

        public boolean isJUnit() {
            return this.isJUnit;
        }

        public boolean isGameTest() {
            return this.isGameTest;
        }

        public Multimap<String, SourceSet> getModSources() {
            return this.modSources;
        }

        public Multimap<String, SourceSet> getUnitTestSources() {
            return this.unitTestSources;
        }

        public Set<String> getClasspath() {
            return this.classpath;
        }

        public Set<String> getDependencies() {
            return this.dependencies;
        }
    }
}

