/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.run;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.util.DelegatingDomainObjectContainer;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runs.type.RunTypeManager;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;

public class RunTypeManagerImpl
extends DelegatingDomainObjectContainer<RunType>
implements RunTypeManager {
    private final List<RunTypeManager.Parser> parsers = new ArrayList<RunTypeManager.Parser>();

    private static NamedDomainObjectContainer<RunType> createAndRegisterContainer(Project project) {
        NamedDomainObjectContainer container = project.container(RunType.class, name -> {
            Run template = (Run)project.getObjects().newInstance(RunImpl.class, new Object[]{project, "template" + StringUtils.capitalize((String)name)});
            RunType type = (RunType)project.getObjects().newInstance(RunType.class, new Object[]{name});
            type.setRunTemplate(template);
            return type;
        });
        project.getExtensions().add("runTypes", (Object)container);
        return container;
    }

    @Inject
    public RunTypeManagerImpl(Project project) {
        super(RunTypeManagerImpl.createAndRegisterContainer(project));
    }

    public Collection<RunType> parse(File file) {
        if (!file.exists()) {
            return Collections.emptyList();
        }
        return this.parsers.stream().flatMap(parser -> {
            try {
                return parser.parse(file).stream();
            }
            catch (Exception exception) {
                return Stream.empty();
            }
        }).collect(Collectors.toSet());
    }

    public void registerParser(RunTypeManager.Parser parser) {
        this.parsers.add(parser);
    }
}

