/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.run;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.util.DelegatingDomainObjectContainer;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;

public class RunManagerImpl
extends DelegatingDomainObjectContainer<Run>
implements RunManager {
    private final List<Action<Run>> actions = new ArrayList<Action<Run>>();
    private final List<Run> internalRuns = new ArrayList<Run>();

    private static NamedDomainObjectContainer<Run> createAndRegisterContainer(Project project) {
        NamedDomainObjectContainer container = project.container(Run.class, name -> (Run)project.getObjects().newInstance(RunImpl.class, new Object[]{project, name}));
        project.getExtensions().add("runs", (Object)container);
        return container;
    }

    @Inject
    public RunManagerImpl(Project project) {
        super(RunManagerImpl.createAndRegisterContainer(project));
    }

    public void addInternal(Run run) {
        this.internalRuns.add(run);
        for (Action<Run> action : this.actions) {
            action.execute((Object)run);
        }
    }

    public void realizeAll(Action<Run> forAll) {
        super.all(forAll);
        this.actions.add(forAll);
        for (Run run : this.internalRuns) {
            forAll.execute((Object)run);
        }
    }

    public void configureAll(Action<Run> configure) {
        super.configureEach(configure);
        this.actions.add(configure);
        for (Run run : this.internalRuns) {
            configure.execute((Object)run);
        }
    }
}

