/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.run;

import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.extensions.NeoGradleProblemReporter;
import net.neoforged.gradle.common.runs.run.DependencyHandlerImpl;
import net.neoforged.gradle.common.runs.run.RunDevLoginOptionsImpl;
import net.neoforged.gradle.common.runs.run.RunRenderDocOptionsImpl;
import net.neoforged.gradle.common.runs.run.RunSourceSetsImpl;
import net.neoforged.gradle.common.runs.run.RunTestScopeImpl;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.common.util.TaskDependencyUtils;
import net.neoforged.gradle.common.util.exceptions.MultipleDefinitionsFoundException;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.runs.DevLogin;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.runs.RenderDoc;
import net.neoforged.gradle.dsl.common.runs.RunSpecification;
import net.neoforged.gradle.dsl.common.runs.run.DependencyHandler;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunDevLoginOptions;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import net.neoforged.gradle.dsl.common.runs.run.RunRenderDocOptions;
import net.neoforged.gradle.dsl.common.runs.run.RunSourceSets;
import net.neoforged.gradle.dsl.common.runs.run.RunTestScope;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runs.type.RunTypeManager;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;

public abstract class RunImpl
implements ConfigurableDSLElement<Run>,
Run {
    private final Project project;
    private final String name;
    private final ListProperty<RunSpecification> rawSpecifications;
    private final ListProperty<RunSpecification> specifications;
    private final RunSourceSets modSources;
    private final RunSourceSets unitTestSources;
    private final RunTestScope testScope;
    private final RunRenderDocOptions renderDocOptions;
    private final RunDevLoginOptions devLoginOptions;
    private final DependencyHandler dependencies;
    private ListProperty<String> jvmArguments;
    private MapProperty<String, String> environmentVariables;
    private ListProperty<String> programArguments;
    private MapProperty<String, String> systemProperties;

    @Inject
    public RunImpl(Project project, String name) {
        this.project = project;
        this.name = name;
        this.modSources = (RunSourceSets)project.getObjects().newInstance(RunSourceSetsImpl.class, new Object[]{project});
        this.unitTestSources = (RunSourceSets)project.getObjects().newInstance(RunSourceSetsImpl.class, new Object[]{project});
        this.testScope = (RunTestScope)project.getObjects().newInstance(RunTestScopeImpl.class, new Object[]{project});
        this.renderDocOptions = (RunRenderDocOptions)project.getObjects().newInstance(RunRenderDocOptionsImpl.class, new Object[]{project, this});
        this.devLoginOptions = (RunDevLoginOptions)project.getObjects().newInstance(RunDevLoginOptionsImpl.class, new Object[]{project, this});
        this.dependencies = (DependencyHandler)project.getObjects().newInstance(DependencyHandlerImpl.class, new Object[]{project, String.format("RunDependencies%s", StringCapitalizationUtils.capitalize((String)name))});
        this.jvmArguments = this.project.getObjects().listProperty(String.class);
        this.environmentVariables = this.project.getObjects().mapProperty(String.class, String.class);
        this.programArguments = this.project.getObjects().listProperty(String.class);
        this.systemProperties = this.project.getObjects().mapProperty(String.class, String.class);
        this.rawSpecifications = this.project.getObjects().listProperty(RunSpecification.class);
        this.specifications = this.project.getObjects().listProperty(RunSpecification.class);
        this.specifications.addAll(this.rawSpecifications);
        this.getIsSingleInstance().convention((Object)true);
        this.getIsClient().convention((Object)false);
        this.getIsServer().convention((Object)false);
        this.getIsDataGenerator().convention((Object)false);
        this.getIsGameTest().convention((Object)false);
        this.getIsJUnit().convention((Object)false);
        this.getConfigureAutomatically().convention((Object)true);
        this.getConfigureFromTypeWithName().convention((Provider)this.getConfigureAutomatically());
        this.getConfigureFromDependencies().convention((Provider)this.getConfigureAutomatically());
        this.getWorkingDirectory().convention(project.getLayout().getProjectDirectory().dir("runs").dir(this.getName()));
        this.getRuntimeClasspath().from(new Object[]{this.getModSources().all().map(Multimap::values).map(sourcesSets -> sourcesSets.stream().map(SourceSet::getRuntimeClasspath).toList())});
        this.getTestRuntimeClasspath().from(new Object[]{this.getRuntimeClasspath()});
        this.getTestRuntimeClasspath().from(new Object[]{this.getUnitTestSources().all().map(Multimap::values).map(sourcesSets -> sourcesSets.stream().map(SourceSet::getRuntimeClasspath).toList())});
        this.getCompileClasspath().from(new Object[]{this.getModSources().all().map(Multimap::values).map(sourcesSets -> sourcesSets.stream().map(SourceSet::getCompileClasspath).toList())});
        this.getTestCompileClasspath().from(new Object[]{this.getCompileClasspath()});
        this.getTestCompileClasspath().from(new Object[]{this.getUnitTestSources().all().map(Multimap::values).map(sourcesSets -> sourcesSets.stream().map(SourceSet::getCompileClasspath).toList())});
        this.getSdkClasspath().from(new Object[]{this.getModSources().all().map(Multimap::values).map(sourcesSets -> sourcesSets.stream().map(ConfigurationUtils::getSdkConfiguration).toList())});
        this.getSdkClasspath().from(new Object[]{this.getUnitTestSources().all().map(Multimap::values).map(sourcesSets -> sourcesSets.stream().map(ConfigurationUtils::getSdkConfiguration).toList())});
        this.getShouldExportToIDE().convention((Object)true);
    }

    public Project getProject() {
        return this.project;
    }

    public final String getName() {
        return this.name;
    }

    public MapProperty<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void overrideEnvironmentVariables(MapProperty<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public RunRenderDocOptions getRenderDoc() {
        return this.renderDocOptions;
    }

    public RunDevLoginOptions getDevLogin() {
        return this.devLoginOptions;
    }

    public DependencyHandler getDependencies() {
        return this.dependencies;
    }

    public RunSourceSets getUnitTestSources() {
        return this.unitTestSources;
    }

    public void unitTestSource(@NotNull SourceSet sourceSet) {
        this.getUnitTestSources().add(sourceSet);
    }

    public void unitTestSources(SourceSet ... sourceSets) {
        this.getUnitTestSources().add(sourceSets);
    }

    public void unitTestSources(@NotNull Iterable<? extends SourceSet> sourceSets) {
        this.getUnitTestSources().add(sourceSets);
    }

    public RunSourceSets getModSources() {
        return this.modSources;
    }

    public void modSource(@NotNull SourceSet sourceSet) {
        this.getModSources().add(sourceSet);
    }

    public void modSources(SourceSet ... sourceSets) {
        this.getModSources().add(sourceSets);
    }

    public void modSources(@NotNull Iterable<? extends SourceSet> sourceSets) {
        this.getModSources().add(sourceSets);
    }

    public ListProperty<String> getArguments() {
        return this.programArguments;
    }

    public void overrideArguments(ListProperty<String> arguments) {
        this.programArguments = arguments;
    }

    @Deprecated
    public ListProperty<String> getProgramArguments() {
        ((NeoGradleProblemReporter)this.getProject().getExtensions().getByType(NeoGradleProblemReporter.class)).reporting((Action<NeoGradleProblemReporter.NeoGradleProblemSpec>)((Action)problem -> problem.id("deprecated-method", "Deprecated method").contextualLabel("Run.getProgramArguments()").details("The method getProgramArguments() is deprecated and will be removed in the future").solution("Use getArguments() instead of getProgramArguments()").section("common-runs-configuration-types-configure-by-type")), this.getProject().getLogger());
        return this.programArguments;
    }

    public ListProperty<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public void overrideJvmArguments(ListProperty<String> args) {
        this.jvmArguments = args;
    }

    public MapProperty<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void overrideSystemProperties(MapProperty<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    private Provider<Set<FileSystemLocation>> getLooselyCoupledConfigurableFileCollectionElements(ConfigurableFileCollection collection) {
        return this.project.provider(() -> (Set)collection.getElements().get());
    }

    public Provider<Set<FileSystemLocation>> getRuntimeClasspathElements() {
        return this.getLooselyCoupledConfigurableFileCollectionElements(this.getRuntimeClasspath());
    }

    public Provider<Set<FileSystemLocation>> getTestRuntimeClasspathElements() {
        return this.getLooselyCoupledConfigurableFileCollectionElements(this.getTestRuntimeClasspath());
    }

    public Provider<Set<FileSystemLocation>> getCompileClasspathElements() {
        return this.getLooselyCoupledConfigurableFileCollectionElements(this.getCompileClasspath());
    }

    public Provider<Set<FileSystemLocation>> getTestCompileClasspathElements() {
        return this.getLooselyCoupledConfigurableFileCollectionElements(this.getTestCompileClasspath());
    }

    public Provider<Set<FileSystemLocation>> getSdkClasspathElements() {
        return this.getLooselyCoupledConfigurableFileCollectionElements(this.getSdkClasspath());
    }

    public void runType(@NotNull String name) {
        this.getConfigureFromTypeWithName().set((Object)false);
        this.rawSpecifications.addAll(this.getRunTypesByName(name));
    }

    public void run(@NotNull String name) {
        this.getConfigureFromTypeWithName().set((Object)false);
        this.rawSpecifications.addAll(this.getRunByName(name));
    }

    public RunTestScope getTestScope() {
        return this.testScope;
    }

    public final void configure() {
        this.potentiallyAddRunTypeByName();
        this.potentiallyAddRunTemplateFromType();
        this.configureRunSpecification();
        this.configureFromSDKs();
        this.configureFromRuns();
    }

    private void potentiallyAddRunTemplateFromType() {
        this.specifications.addAll(this.rawSpecifications.map(l -> l.stream().filter(RunType.class::isInstance).map(RunType.class::cast).map(RunType::getRunTemplate).filter(Objects::nonNull).toList()));
    }

    private void configureFromRuns() {
        Provider runSpecifications = this.specifications.map(l -> l.stream().filter(Run.class::isInstance).map(Run.class::cast).toList());
        this.getWorkingDirectory().convention(TransformerUtils.defaulted((Provider)runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, Run::getWorkingDirectory)), (Object)this.project.getLayout().getProjectDirectory().dir("runs").dir(this.getName())));
        RenderDoc renderDoc = ((Subsystems)this.project.getExtensions().getByType(Subsystems.class)).getConventions().getRuns().getRenderDoc();
        this.getRenderDoc().getEnabled().convention(TransformerUtils.lazyDefaulted((Provider)runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, run -> run.getRenderDoc().getEnabled())), (Provider)renderDoc.getConventionForRun().zip((Provider)this.getIsClient(), (conventionForRun, isClient) -> conventionForRun != false && isClient != false)));
        DevLogin devLogin = ((Subsystems)this.project.getExtensions().getByType(Subsystems.class)).getConventions().getRuns().getDevLogin();
        this.getDevLogin().getIsEnabled().convention(TransformerUtils.lazyDefaulted((Provider)runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, run -> run.getDevLogin().getIsEnabled())), (Provider)devLogin.getConventionForRun().zip((Provider)this.getIsClient(), (conventionForRun, isClient) -> conventionForRun != false && isClient != false)));
        this.getDevLogin().getProfile().convention(runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, run -> run.getDevLogin().getProfile())));
        this.getModSources().addAllLater(runSpecifications.flatMap(TransformerUtils.combineAllMultiMaps((Project)this.project, String.class, SourceSet.class, run -> run.getModSources().all())));
        this.getUnitTestSources().addAllLater(runSpecifications.flatMap(TransformerUtils.combineAllMultiMaps((Project)this.project, String.class, SourceSet.class, run -> run.getUnitTestSources().all())));
        this.getTestScope().getPackageName().convention(runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, run -> run.getTestScope().getPackageName())));
        this.getTestScope().getDirectory().convention(runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, run -> run.getTestScope().getDirectory())));
        this.getTestScope().getPattern().convention(TransformerUtils.lazyDefaulted((Provider)runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, run -> run.getTestScope().getPattern())), (Provider)this.project.provider(() -> {
            if (this.getTestScope().getPackageName().orElse(this.getTestScope().getDirectory().map(Directory::getAsFile).map(File::getName)).orElse((Provider)this.getTestScope().getClassName()).orElse((Provider)this.getTestScope().getMethod()).orElse((Provider)this.getTestScope().getCategory()).getOrNull() == null) {
                return ".*";
            }
            return null;
        })));
        this.getTestScope().getClassName().convention(runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, run -> run.getTestScope().getClassName())));
        this.getTestScope().getMethod().convention(runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, run -> run.getTestScope().getMethod())));
        this.getTestScope().getCategory().convention(runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, run -> run.getTestScope().getCategory())));
        this.getDependencies().getRuntime().bundle(runSpecifications.flatMap(TransformerUtils.combineAllSets((Project)this.project, Dependency.class, run -> run.getDependencies().getRuntime().getDependencies())));
        this.getDependsOn().addAll(runSpecifications.flatMap(TransformerUtils.combineAllSets((Project)this.project, Task.class, Run::getDependsOn)));
        this.getPostSyncTasks().addAll(runSpecifications.flatMap(TransformerUtils.combineAllSets((Project)this.project, Task.class, Run::getPostSyncTasks)));
        this.getShouldExportToIDE().convention(TransformerUtils.defaulted((Provider)runSpecifications.flatMap(TransformerUtils.takeLast((Project)this.project, Run::getShouldExportToIDE)), (Object)true));
    }

    private void configureFromSDKs() {
        HashSet unconfiguredSourceSets = new HashSet();
        HashSet configuredDefinitions = new HashSet();
        this.getModSources().whenSourceSetAdded(sourceSet -> {
            if (SourceSetUtils.getProject(sourceSet) != this.getProject()) {
                return;
            }
            try {
                Optional<CommonRuntimeDefinition<?>> definition = TaskDependencyUtils.findRuntimeDefinition(sourceSet);
                definition.ifPresentOrElse(def -> {
                    if (configuredDefinitions.add(def)) {
                        def.configureRun(this);
                    }
                }, () -> unconfiguredSourceSets.add(sourceSet));
            }
            catch (MultipleDefinitionsFoundException e) {
                NeoGradleProblemReporter reporter = (NeoGradleProblemReporter)this.project.getExtensions().getByType(NeoGradleProblemReporter.class);
                throw reporter.throwing((Action<NeoGradleProblemReporter.NeoGradleProblemSpec>)((Action)problem -> problem.id("multiple-definitions-found", "Multiple runtime definitions found").contextualLabel("Run: " + this.getName()).solution("Ensure only one SDK definition is present for the source set").details("There are multiple runtime definitions found for the source set: " + sourceSet.getName()).section("common-runs-configuration-runs")));
            }
        });
        DependencyReplacement replacementLogic = (DependencyReplacement)this.project.getExtensions().getByType(DependencyReplacement.class);
        replacementLogic.whenDependencyReplaced((virtualDependency, targetConfiguration, originalDependency) -> {
            if (unconfiguredSourceSets.isEmpty()) {
                return;
            }
            Iterator iterator = unconfiguredSourceSets.iterator();
            while (iterator.hasNext()) {
                SourceSet unconfiguredSourceSet = (SourceSet)iterator.next();
                if (SourceSetUtils.getProject(unconfiguredSourceSet) != this.getProject()) {
                    return;
                }
                try {
                    Optional<CommonRuntimeDefinition<?>> definition = TaskDependencyUtils.findRuntimeDefinition(unconfiguredSourceSet);
                    definition.ifPresent(def -> {
                        if (configuredDefinitions.add(def)) {
                            def.configureRun(this);
                        }
                        iterator.remove();
                    });
                }
                catch (MultipleDefinitionsFoundException e) {
                    throw new RuntimeException("Failed to configure run: " + this.getName() + " there are multiple runtime definitions found for the source set: " + unconfiguredSourceSet.getName(), e);
                }
            }
        });
    }

    private void potentiallyAddRunTypeByName() {
        if (((Boolean)this.getConfigureFromTypeWithName().get()).booleanValue()) {
            this.rawSpecifications.addAll(this.getRunTypesByName(this.name));
        }
    }

    private void configureRunSpecification() {
        this.getEnvironmentVariables().putAll(this.specifications.flatMap(TransformerUtils.combineAllMaps((Project)this.getProject(), String.class, String.class, RunSpecification::getEnvironmentVariables)));
        this.getMainClass().convention(this.specifications.flatMap(TransformerUtils.takeLast((Project)this.getProject(), RunSpecification::getMainClass)));
        this.getArguments().addAll(this.specifications.flatMap(TransformerUtils.combineAllLists((Project)this.getProject(), String.class, RunSpecification::getArguments)));
        this.getJvmArguments().addAll(this.specifications.flatMap(TransformerUtils.combineAllLists((Project)this.getProject(), String.class, RunSpecification::getJvmArguments)));
        this.getIsSingleInstance().convention(TransformerUtils.defaulted((Provider)this.specifications.flatMap(TransformerUtils.takeLast((Project)this.getProject(), RunSpecification::getIsSingleInstance)), (Object)true));
        this.getSystemProperties().putAll(this.specifications.flatMap(TransformerUtils.combineAllMaps((Project)this.getProject(), String.class, String.class, RunSpecification::getSystemProperties)));
        this.getIsClient().convention(TransformerUtils.defaulted((Provider)this.specifications.flatMap(TransformerUtils.takeLast((Project)this.getProject(), RunSpecification::getIsClient)), (Object)false));
        this.getIsServer().convention(TransformerUtils.defaulted((Provider)this.specifications.flatMap(TransformerUtils.takeLast((Project)this.getProject(), RunSpecification::getIsServer)), (Object)false));
        this.getIsDataGenerator().convention(TransformerUtils.defaulted((Provider)this.specifications.flatMap(TransformerUtils.takeLast((Project)this.getProject(), RunSpecification::getIsDataGenerator)), (Object)false));
        this.getIsGameTest().convention(TransformerUtils.defaulted((Provider)this.specifications.flatMap(TransformerUtils.takeLast((Project)this.getProject(), RunSpecification::getIsGameTest)), (Object)false));
        this.getIsJUnit().convention(TransformerUtils.defaulted((Provider)this.specifications.flatMap(TransformerUtils.takeLast((Project)this.getProject(), RunSpecification::getIsJUnit)), (Object)false));
        this.getRuntimeClasspath().from(new Object[]{this.specifications.map(TransformerUtils.combineFileCollections((Project)this.getProject(), RunSpecification::getClasspath))});
    }

    @Deprecated
    public final void configure(@NotNull String name) {
        ((NeoGradleProblemReporter)this.getProject().getExtensions().getByType(NeoGradleProblemReporter.class)).reporting((Action<NeoGradleProblemReporter.NeoGradleProblemSpec>)((Action)problem -> problem.id("deprecated-method", "Deprecated method").contextualLabel("Run.configure(String)").details("The method configure(String) is deprecated and will be removed in the future").solution("Use Run.runType(String) or Run.run(String) instead of Run.configure(String) to indicate from what the run should be configured").section("common-runs-configuration-types-configure-by-type")), this.getProject().getLogger());
        this.getConfigureFromTypeWithName().set((Object)false);
        this.rawSpecifications.addAll(this.getRunTypesByName(name));
    }

    public final void configure(@NotNull RunSpecification runType) {
        this.getConfigureFromTypeWithName().set((Object)false);
        this.rawSpecifications.add(this.project.provider(() -> runType));
    }

    public void configure(@NotNull Provider<? extends RunSpecification> typeProvider) {
        this.getConfigureFromTypeWithName().set((Object)false);
        this.rawSpecifications.add(typeProvider);
    }

    @NotNull
    public List<String> realiseJvmArguments() {
        ArrayList<String> args = new ArrayList<String>((Collection)this.getJvmArguments().get());
        for (Map.Entry entry : ((Map)this.getSystemProperties().get()).entrySet()) {
            if (entry.getValue() != null && !((String)entry.getValue()).isEmpty()) {
                args.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
                continue;
            }
            args.add("-D" + (String)entry.getKey());
        }
        return args;
    }

    private Provider<List<RunType>> getRunTypesByName(String name) {
        RunTypeManager runTypes = (RunTypeManager)this.project.getExtensions().getByType(RunTypeManager.class);
        return this.project.provider(() -> {
            if (runTypes.getNames().contains(name)) {
                return List.of((RunType)runTypes.getByName(name));
            }
            return null;
        }).orElse(TransformerUtils.ifTrue((Provider)this.getConfigureFromDependencies(), (Provider)this.getSdkClasspathElements().map(files -> files.stream().map(FileSystemLocation::getAsFile).map(arg_0 -> ((RunTypeManager)runTypes).parse(arg_0)).flatMap(Collection::stream).filter(runType -> runType.getName().equals(name)).toList()))).map(types -> {
            if (types.isEmpty()) {
                NeoGradleProblemReporter reporter = (NeoGradleProblemReporter)this.project.getExtensions().getByType(NeoGradleProblemReporter.class);
                throw reporter.throwing((Action<NeoGradleProblemReporter.NeoGradleProblemSpec>)((Action)problem -> problem.id("run-type-not-found", "Run type not found").contextualLabel("The run type '%s' was not found".formatted(name)).solution("Ensure the run type is defined in the run or a dependency").section("common-runs-configuration-types-configure-by-type")));
            }
            return types;
        });
    }

    private Provider<List<Run>> getRunByName(String name) {
        RunManager runTypes = (RunManager)this.project.getExtensions().getByType(RunManager.class);
        return this.project.provider(() -> {
            if (runTypes.getNames().contains(name)) {
                return List.of((Run)runTypes.getByName(name));
            }
            return null;
        }).orElse(List.of());
    }
}

