/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.sourcesets;

import javax.inject.Inject;
import net.neoforged.gradle.common.extensions.NeoGradleProblemReporter;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.dsl.common.extensions.sourceset.SourceSetDependencyExtension;
import net.neoforged.gradle.dsl.common.extensions.sourceset.SourceSetInheritanceExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;

public abstract class SourceSetDependencyExtensionImpl
implements SourceSetDependencyExtension {
    private final Project project;
    private final SourceSet target;

    @Inject
    public SourceSetDependencyExtensionImpl(SourceSet target) {
        this.project = SourceSetUtils.getProject(target);
        this.target = target;
    }

    public Project getProject() {
        return this.project;
    }

    public void on(SourceSet sourceSet) {
        Project sourceSetProject = SourceSetUtils.getProject(sourceSet);
        if (sourceSetProject != this.project) {
            NeoGradleProblemReporter reporter = (NeoGradleProblemReporter)this.project.getExtensions().getByType(NeoGradleProblemReporter.class);
            throw reporter.throwing((Action<NeoGradleProblemReporter.NeoGradleProblemSpec>)((Action)spec -> spec.id("source-set-dependencies", "wrong-project").contextualLabel("on(SourceSet)").details("SourceSet '%s' is not from the same project as the current SourceSet '%s', as such it can not depend on it".formatted(sourceSet.getName(), this.project.getName())).section("common-dep-sourceset-management-depend").solution("Ensure that the SourceSet is from the same project as the current SourceSet")));
        }
        SourceSetInheritanceExtension sourceSetInheritanceExtension = (SourceSetInheritanceExtension)this.target.getExtensions().getByType(SourceSetInheritanceExtension.class);
        sourceSetInheritanceExtension.from(sourceSet);
        this.project.getDependencies().add(this.target.getImplementationConfigurationName(), (Object)sourceSet.getOutput());
    }
}

