/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.repository;

import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.neoforged.gradle.util.IndentingXmlStreamWriter;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;

public final class IvyModuleWriter
implements AutoCloseable {
    private static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String IVY = "http://ant.apache.org/ivy/schemas/ivy.xsd";
    private static final String NEOGRADLE = "https://neoforged.net/neogradle/ivy-extra";
    private static final XMLOutputFactory OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String INDENT = "  ";
    private final boolean managedOutput;
    private final Writer output;
    private final XMLStreamWriter writer;

    public IvyModuleWriter(Writer output) throws XMLStreamException {
        this.managedOutput = false;
        this.output = output;
        this.writer = new IndentingXmlStreamWriter(OUTPUT_FACTORY.createXMLStreamWriter(output), INDENT);
    }

    public IvyModuleWriter(Path target) throws IOException, XMLStreamException {
        this.managedOutput = true;
        this.output = Files.newBufferedWriter(target, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        this.writer = new IndentingXmlStreamWriter(OUTPUT_FACTORY.createXMLStreamWriter(this.output), INDENT);
    }

    public void write(Dependency descriptor, Configuration dependencies) throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("ivy-module");
        this.writer.writeNamespace("xsi", XSI);
        this.writer.writeNamespace("NeoGradle", NEOGRADLE);
        this.writer.writeAttribute(XSI, "noNamespaceSchemaLocation", IVY);
        this.writer.writeAttribute("version", "2.0");
        this.writeInfo(descriptor);
        this.writeDependencies(dependencies);
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
    }

    private void writeInfo(Dependency entry) throws XMLStreamException {
        this.writer.writeStartElement("info");
        if (entry.getGroup() != null) {
            this.writer.writeAttribute("organisation", entry.getGroup());
        }
        this.writer.writeAttribute("module", entry.getName());
        this.writer.writeAttribute("revision", entry.getVersion());
        this.writer.writeAttribute("status", "release");
        this.writer.writeEmptyElement("license");
        this.writer.writeAttribute("name", "Minecraft EULA");
        this.writer.writeAttribute("url", "https://www.minecraft.net/en-us/eula");
        this.writer.writeEndElement();
    }

    private void writeDependencies(Configuration dependencies) throws XMLStreamException {
        this.writer.writeStartElement("dependencies");
        for (ResolvedArtifact extra : dependencies.getResolvedConfiguration().getResolvedArtifacts()) {
            this.writeDependency(extra);
        }
        this.writer.writeEndElement();
    }

    private void writeDependency(ResolvedArtifact dep) throws XMLStreamException {
        boolean hasClassifier;
        String classifier = dep.getClassifier() == null ? "" : dep.getClassifier();
        boolean bl = hasClassifier = !classifier.isEmpty();
        if (hasClassifier) {
            this.writer.writeStartElement("dependency");
        } else {
            this.writer.writeEmptyElement("dependency");
        }
        this.writer.writeAttribute("org", dep.getModuleVersion().getId().getGroup());
        this.writer.writeAttribute("name", dep.getModuleVersion().getId().getName());
        this.writer.writeAttribute("rev", dep.getModuleVersion().getId().getVersion());
        this.writer.writeAttribute("transitive", "false");
        if (hasClassifier) {
            this.writer.writeEmptyElement("artifact");
            this.writer.writeAttribute("name", dep.getModuleVersion().getId().getName());
            this.writer.writeAttribute("classifier", classifier);
            this.writer.writeAttribute("ext", "jar");
            this.writer.writeEndElement();
        }
    }

    @Override
    public void close() throws IOException, XMLStreamException {
        this.writer.close();
        if (this.managedOutput) {
            this.output.close();
        }
    }
}

