/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.repository;

import java.io.Serializable;
import javax.inject.Inject;
import net.minecraftforge.gdi.BaseDSLElement;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.extensions.repository.Entry;
import net.neoforged.gradle.util.ModuleDependencyUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;

public abstract class IvyEntry
implements BaseDSLElement<Entry>,
Entry,
Serializable {
    private final Project project;
    private final Dependency original;
    private final Dependency dependency;
    private final Configuration dependencies;
    private final boolean hasSources;

    @Inject
    public IvyEntry(Project project, Dependency original, Dependency dependency, Configuration dependencies, boolean hasSources) {
        this.project = project;
        this.original = original;
        this.dependency = dependency;
        this.dependencies = dependencies;
        this.hasSources = hasSources;
    }

    public Project getProject() {
        return this.project;
    }

    public Dependency getOriginal() {
        return this.original;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public Configuration getDependencies() {
        return this.dependencies;
    }

    public boolean hasSources() {
        return this.hasSources;
    }

    public static abstract class Builder
    implements Entry.Builder {
        private final Project project;
        private Dependency original;
        private Dependency dependency;
        private Configuration dependencies;
        private boolean hasSources = true;

        @Inject
        public Builder(Project project) {
            this.project = project;
        }

        public Project getProject() {
            return this.project;
        }

        public Entry.Builder from(Dependency dependency) {
            return this.from(dependency, ConfigurationUtils.temporaryUnhandledConfiguration(this.project.getConfigurations(), "EmptyDependenciesFor" + ModuleDependencyUtils.toConfigurationName((Dependency)dependency), new Dependency[0]));
        }

        public Entry.Builder from(Dependency dependency, Configuration dependencies) {
            this.original = dependency;
            this.dependency = this.wrap(dependency);
            this.dependencies = dependencies;
            return this;
        }

        public Entry.Builder withoutSources() {
            this.hasSources = false;
            return this;
        }

        public Entry build() {
            return (Entry)this.project.getObjects().newInstance(IvyEntry.class, new Object[]{this.project, this.original, this.dependency, this.dependencies, this.hasSources});
        }

        private Dependency wrap(Dependency dependency) {
            if (!(dependency instanceof ExternalModuleDependency)) {
                throw new IllegalArgumentException("Dependency must be an ExternalModuleDependency");
            }
            String gav = ModuleDependencyUtils.format((ModuleDependency)((ExternalModuleDependency)dependency));
            return this.project.getDependencies().create((Object)("ng_dummy_ng." + gav));
        }
    }
}

