/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.base;

import java.util.List;
import net.neoforged.gradle.common.extensions.base.WithPropertyLookup;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public abstract class WithEnabledProperty
extends WithPropertyLookup {
    private final String prefix;

    public WithEnabledProperty(Project project, String prefix) {
        super(project);
        this.prefix = prefix;
        this.getIsEnabled().set(this.getBooleanLocalProperty("enabled", true));
    }

    public WithEnabledProperty(WithEnabledProperty parent, String prefix) {
        super(parent.project);
        this.prefix = String.format("%s.%s", parent.prefix, prefix);
        this.getIsEnabled().set(parent.getIsEnabled().zip(this.getBooleanLocalProperty("enabled", true), (parentEnabled, enabled) -> parentEnabled != false && enabled != false));
    }

    public abstract Property<Boolean> getIsEnabled();

    protected Provider<String> getStringLocalProperty(String propertyName, String defaultValue) {
        return super.getStringProperty(String.format("%s.%s", this.prefix, propertyName), defaultValue);
    }

    protected Provider<Directory> getDirectoryLocalProperty(String propertyName, Provider<Directory> defaultValue) {
        return super.getDirectoryProperty(String.format("%s.%s", this.prefix, propertyName), defaultValue);
    }

    protected Provider<Boolean> getBooleanLocalProperty(String propertyName, boolean defaultValue) {
        return super.getBooleanProperty(String.format("%s.%s", this.prefix, propertyName), defaultValue, false);
    }

    protected Provider<List<String>> getSpaceSeparatedListLocalProperty(String propertyName, List<String> defaultValue) {
        return super.getSpaceSeparatedListProperty(String.format("%s.%s", this.prefix, propertyName), defaultValue);
    }

    @Override
    protected Provider<String> getStringProperty(String propertyName, String defaultValue) {
        return this.getIsEnabled().zip(this.getStringLocalProperty(propertyName, defaultValue), (enabled, value) -> enabled != false ? value : "");
    }

    @Override
    protected Provider<Directory> getDirectoryProperty(String propertyName, Provider<Directory> defaultValue) {
        return this.getIsEnabled().zip(this.getDirectoryLocalProperty(propertyName, defaultValue), (enabled, value) -> enabled != false ? value : null);
    }

    @Override
    protected Provider<Boolean> getBooleanProperty(String propertyName, boolean defaultValue, boolean disabledValue) {
        return this.getIsEnabled().zip(this.getBooleanLocalProperty(propertyName, defaultValue), (enabled, value) -> enabled != false ? value : disabledValue);
    }

    @Override
    protected Provider<List<String>> getSpaceSeparatedListProperty(String propertyName, List<String> defaultValue) {
        return this.getIsEnabled().zip(this.getSpaceSeparatedListLocalProperty(propertyName, defaultValue), (enabled, value) -> enabled != false ? value : List.of());
    }
}

