/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;

public class ProjectEvaluationExtension {
    private final Project project;
    private boolean isEvaluated = false;

    @Inject
    public ProjectEvaluationExtension(Project project) {
        this.project = project;
        this.project.afterEvaluate(project1 -> this.setEvaluated());
    }

    public Project getProject() {
        return this.project;
    }

    public void afterEvaluate(Action<? super Project> action) {
        if (this.isEvaluated()) {
            action.execute((Object)this.getProject());
        } else {
            this.getProject().afterEvaluate(action);
        }
    }

    private boolean isEvaluated() {
        return this.isEvaluated;
    }

    private void setEvaluated() {
        this.isEvaluated = true;
    }
}

