/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import net.neoforged.gradle.common.util.NeoGradleUtils;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logger;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.Severity;

public class NeoGradleProblemReporter {
    private final ProblemReporter delegate;

    public NeoGradleProblemReporter(ProblemReporter delegate) {
        this.delegate = delegate;
    }

    public void reporting(Action<NeoGradleProblemSpec> spec, Logger logger) {
        this.delegate.reporting(problemSpec -> {
            NeoGradleProblemSpec neoGradleProblemSpec = new NeoGradleProblemSpec();
            spec.execute((Object)neoGradleProblemSpec);
            String url = NeoGradleProblemReporter.readMeUrl(neoGradleProblemSpec.section);
            problemSpec.id(neoGradleProblemSpec.category, neoGradleProblemSpec.id).contextualLabel(neoGradleProblemSpec.contextualLabel).solution(neoGradleProblemSpec.solution).details(neoGradleProblemSpec.details).severity(Severity.WARNING).documentedAt(url);
            neoGradleProblemSpec.log(logger);
        });
    }

    public RuntimeException throwing(Action<NeoGradleProblemSpec> spec) {
        return this.delegate.throwing(problemSpec -> {
            NeoGradleProblemSpec neoGradleProblemSpec = new NeoGradleProblemSpec();
            spec.execute((Object)neoGradleProblemSpec);
            String url = NeoGradleProblemReporter.readMeUrl(neoGradleProblemSpec.section);
            problemSpec.id(neoGradleProblemSpec.category, neoGradleProblemSpec.id).contextualLabel(neoGradleProblemSpec.contextualLabel).solution(neoGradleProblemSpec.solution).details(neoGradleProblemSpec.details).severity(Severity.ERROR).withException((RuntimeException)new InvalidUserDataException("(%s) %s.\nPotential Solution: %s.\nMore information: %s".formatted(neoGradleProblemSpec.contextualLabel, neoGradleProblemSpec.details, neoGradleProblemSpec.solution, url))).documentedAt(url);
        });
    }

    private static String readMeUrl(String section) {
        String neogradleVersion = NeoGradleUtils.getNeogradleVersion();
        String branchMajorVersion = neogradleVersion.split("\\.")[0];
        String branchMinorVersion = neogradleVersion.split("\\.")[1];
        String branch = "NG_%s.%s".formatted(branchMajorVersion, branchMinorVersion);
        return "https://github.com/neoforged/NeoGradle/blob/%s/README.md#%s".formatted(branch, section);
    }

    public static final class NeoGradleProblemSpec {
        private String category;
        private String id;
        private String contextualLabel;
        private String solution;
        private String details;
        private String section;

        public NeoGradleProblemSpec id(String category, String id) {
            this.category = category;
            this.id = id;
            return this;
        }

        public NeoGradleProblemSpec contextualLabel(String contextualLabel) {
            this.contextualLabel = contextualLabel;
            return this;
        }

        public NeoGradleProblemSpec solution(String solution) {
            this.solution = solution;
            return this;
        }

        public NeoGradleProblemSpec details(String details) {
            this.details = details;
            return this;
        }

        public NeoGradleProblemSpec section(String section) {
            this.section = section;
            return this;
        }

        private void log(Logger logger) {
            logger.warn("-------------------------------------");
            logger.warn("NeoGradle detected a problem with your project: %s".formatted(this.contextualLabel));
            logger.warn("Details: %s".formatted(this.details));
            logger.warn("Potential Solution: %s".formatted(this.solution));
            logger.warn("More information: %s".formatted(NeoGradleProblemReporter.readMeUrl(this.section)));
            logger.warn("-------------------------------------");
        }
    }
}

