/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.remapper;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.msrandom.minecraftcodev.core.MinecraftCodevPlugin;
import net.msrandom.minecraftcodev.remapper.MappingResolutionData;
import net.msrandom.minecraftcodev.remapper.MappingResolutionRule;
import net.msrandom.minecraftcodev.remapper.MappingTreeProvider;
import net.msrandom.minecraftcodev.remapper.Parchment;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r\u001a*\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\b0\u0018\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\" \u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"mappingResolutionRules", "", "Lnet/msrandom/minecraftcodev/remapper/MappingResolutionRule;", "getMappingResolutionRules", "()Ljava/lang/Iterable;", "mappingsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/io/File;", "Lnet/fabricmc/mappingio/tree/MappingTreeView;", "handleParchment", "", "data", "Lnet/msrandom/minecraftcodev/remapper/MappingResolutionData;", "path", "Ljava/nio/file/Path;", "loadMappingFile", "file", "loadMappings", "files", "Lorg/gradle/api/file/FileCollection;", "execOperations", "Lorg/gradle/process/ExecOperations;", "extraFiles", "", "", "minecraft-codev-remapper"})
@SourceDebugExtension(value={"SMAP\nMappingResolutionRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingResolutionRule.kt\nnet/msrandom/minecraftcodev/remapper/MappingResolutionRuleKt\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 4 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Services.kt\nnet/msrandom/minecraftcodev/core/utils/ServicesKt\n*L\n1#1,230:1\n82#2:231\n32#3:232\n80#4:233\n1855#5:234\n1855#5,2:235\n1855#5:237\n1855#5,2:238\n1856#5:240\n1856#5:241\n5#6:242\n*S KotlinDebug\n*F\n+ 1 MappingResolutionRule.kt\nnet/msrandom/minecraftcodev/remapper/MappingResolutionRuleKt\n*L\n167#1:231\n167#1:232\n167#1:233\n176#1:234\n194#1:235,2\n207#1:237\n219#1:238,2\n207#1:240\n176#1:241\n124#1:242\n*E\n"})
public final class MappingResolutionRuleKt {
    @NotNull
    private static final Iterable<MappingResolutionRule> mappingResolutionRules;
    @NotNull
    private static final ConcurrentHashMap<Set<File>, MappingTreeView> mappingsCache;

    @NotNull
    public static final Iterable<MappingResolutionRule> getMappingResolutionRules() {
        return mappingResolutionRules;
    }

    public static final void loadMappingFile(@NotNull Path file, @NotNull MappingResolutionData data) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        for (MappingResolutionRule rule : mappingResolutionRules) {
            if (!rule.load(file, PathsKt.getExtension((Path)file), data)) continue;
            return;
        }
        throw new UnsupportedOperationException("Unknown mapping file format " + file);
    }

    @NotNull
    public static final MappingTreeView loadMappings(@NotNull FileCollection files, @NotNull ExecOperations execOperations, @NotNull Map<String, ? extends File> extraFiles) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        Intrinsics.checkNotNullParameter(extraFiles, (String)"extraFiles");
        MappingTreeView mappingTreeView = mappingsCache.computeIfAbsent(files.getFiles(), arg_0 -> MappingResolutionRuleKt.loadMappings$lambda$0((Function1)new Function1<Set<? extends File>, MappingTreeView>(files, execOperations, extraFiles){
            final /* synthetic */ FileCollection $files;
            final /* synthetic */ ExecOperations $execOperations;
            final /* synthetic */ Map<String, File> $extraFiles;
            {
                this.$files = $files;
                this.$execOperations = $execOperations;
                this.$extraFiles = $extraFiles;
                super(1);
            }

            @NotNull
            public final MappingTreeView invoke(@NotNull Set<? extends File> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                System.out.println((Object)("Loading mappings " + this.$files));
                MemoryMappingTree tree = new MemoryMappingTree();
                MappingResolutionData data = new MappingResolutionData(new MappingTreeProvider(tree), this.$execOperations, this.$extraFiles);
                for (File file : it) {
                    Path path = file.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
                    MappingResolutionRuleKt.loadMappingFile(path, data);
                }
                return (MappingTreeView)tree;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mappingTreeView, (String)"files: FileCollection,\n \u2026, data)\n    }\n\n    tree\n}");
        return mappingTreeView;
    }

    private static final void handleParchment(MappingResolutionData data, Path path) {
        ((MappingTreeProvider)data.getVisitor()).withTree("named", (Action<MemoryMappingTree>)((Action)arg_0 -> MappingResolutionRuleKt.handleParchment$lambda$7(path, arg_0)));
    }

    private static final MappingTreeView loadMappings$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MappingTreeView)$tmp0.invoke(p0);
    }

    private static final void handleParchment$lambda$7$lambda$6$visitComment(MemoryMappingTree visitor, Parchment.Element element, MappedElementKind type) {
        block1: {
            Parchment.Javadoc javadoc = element.getJavadoc();
            if (javadoc == null) break block1;
            Parchment.Javadoc it = javadoc;
            boolean bl = false;
            if (!((Collection)it.getLines()).isEmpty()) {
                visitor.visitComment(type, CollectionsKt.joinToString$default((Iterable)it.getLines(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleParchment$lambda$7(Path $path, MemoryMappingTree it) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        MemoryMappingTree visitor = it;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            Object it2 = (InputStream)closeable;
            boolean bl = false;
            Json $this$decodeFromStream$iv = MinecraftCodevPlugin.Companion.getJson();
            boolean $i$f$decodeFromStream = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromStream$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(Parchment.class));
            boolean $i$f$cast = false;
            it2 = (Parchment)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)$this$cast$iv$iv$iv), (InputStream)it2);
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object parchment = it2;
        do {
            if (visitor.visitHeader()) {
                visitor.visitNamespaces("named", CollectionsKt.emptyList());
            }
            if (!visitor.visitContent()) continue;
            List<Parchment.ClassElement> list = ((Parchment)parchment).getClasses();
            if (list == null) continue;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Parchment.ClassElement classElement = (Parchment.ClassElement)element$iv;
                boolean bl = false;
                if (!visitor.visitClass(classElement.getName()) || !visitor.visitElementContent(MappedElementKind.CLASS)) continue;
                MappingResolutionRuleKt.handleParchment$lambda$7$lambda$6$visitComment(visitor, classElement, MappedElementKind.CLASS);
                List<Parchment.ClassElement.FieldElement> list2 = classElement.getFields();
                if (list2 != null) {
                    Iterable $this$forEach$iv2 = list2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Parchment.ClassElement.FieldElement fieldElement = (Parchment.ClassElement.FieldElement)element$iv2;
                        boolean bl2 = false;
                        if (!visitor.visitField(fieldElement.getName(), fieldElement.getDescriptor()) || !visitor.visitElementContent(MappedElementKind.METHOD)) continue;
                        MappingResolutionRuleKt.handleParchment$lambda$7$lambda$6$visitComment(visitor, fieldElement, MappedElementKind.FIELD);
                    }
                }
                List<Parchment.ClassElement.MethodElement> list3 = classElement.getMethods();
                if (list3 == null) continue;
                Iterable $this$forEach$iv3 = list3;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    Parchment.ClassElement.MethodElement methodElement = (Parchment.ClassElement.MethodElement)element$iv2;
                    boolean bl3 = false;
                    if (!visitor.visitMethod(methodElement.getName(), methodElement.getDescriptor()) || !visitor.visitElementContent(MappedElementKind.METHOD)) continue;
                    MappingResolutionRuleKt.handleParchment$lambda$7$lambda$6$visitComment(visitor, methodElement, MappedElementKind.METHOD);
                    List<Parchment.ClassElement.MethodElement.ParameterElement> list4 = methodElement.getParameters();
                    if (list4 == null) continue;
                    Iterable $this$forEach$iv4 = list4;
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv3 : $this$forEach$iv4) {
                        Parchment.ClassElement.MethodElement.ParameterElement parameterElement = (Parchment.ClassElement.MethodElement.ParameterElement)element$iv3;
                        boolean bl4 = false;
                        visitor.visitMethodArg(parameterElement.getIndex(), parameterElement.getIndex(), parameterElement.getName());
                        MappingResolutionRuleKt.handleParchment$lambda$7$lambda$6$visitComment(visitor, parameterElement, MappedElementKind.METHOD_ARG);
                    }
                }
            }
        } while (!visitor.visitEnd());
    }

    public static final /* synthetic */ void access$handleParchment(MappingResolutionData data, Path path) {
        MappingResolutionRuleKt.handleParchment(data, path);
    }

    static {
        boolean $i$f$serviceLoader = false;
        ServiceLoader<MappingResolutionRule> serviceLoader = ServiceLoader.load(MappingResolutionRule.class, MappingResolutionRule.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(T::class.java, T::class.java.classLoader)");
        mappingResolutionRules = serviceLoader;
        mappingsCache = new ConcurrentHashMap();
    }
}

