package net.msrandom.minecraftcodev.intersection

import java.io.File
import java.net.URLClassLoader

// deserializeClassToSymbol
// for kotlin metadata, which can be intersected as well etc
// we want to merge normal metadata, except for type aliases
// which do not map to java, so we add them in a kotlin api file
// that might mean reading the type alias locations and intersecting them into a valid kotlin API(which means figuring out properties, etc)

object IntersectionCreator {
    fun create(a: Iterable<File>, b: Iterable<File>) {
        val loaderA = URLClassLoader(a.map {it.toURI().toURL() }.toTypedArray())
        val loaderB = URLClassLoader(a.map {it.toURI().toURL() }.toTypedArray())

        loaderA.getResources("/")
    }
}
