/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.forge.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.minecraftforge.srgutils.IMappingBuilder;
import net.minecraftforge.srgutils.IMappingFile;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\f"}, d2={"Lnet/msrandom/minecraftcodev/forge/task/GenerateMcpToSrg;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "mappings", "Lorg/gradle/api/file/RegularFileProperty;", "getMappings", "()Lorg/gradle/api/file/RegularFileProperty;", "srg", "getSrg", "generate", "", "minecraft-codev-forge"})
public abstract class GenerateMcpToSrg
extends DefaultTask {
    public GenerateMcpToSrg() {
        this.getSrg().convention(this.getProject().getLayout().file(this.getProject().provider(new Callable(){

            public final File call() {
                File file = this.getTemporaryDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getTemporaryDir(...)");
                return FilesKt.resolve((File)file, (String)"mcp.srg");
            }
        })));
    }

    @InputFile
    @NotNull
    public abstract RegularFileProperty getMappings();

    @Internal
    @NotNull
    public abstract RegularFileProperty getSrg();

    @TaskAction
    public final void generate() {
        MemoryMappingTree mappings = new MemoryMappingTree();
        IMappingBuilder srgMappings = IMappingBuilder.create((String[])new String[0]);
        Object object = this.getMappings().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        File file = (File)object;
        Charset charset = Charsets.UTF_8;
        Tiny2FileReader.read((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset), (MappingVisitor)((MappingVisitor)mappings));
        MappingTreeView treeView = (MappingTreeView)mappings;
        int sourceNamespace = treeView.getNamespaceId("srg");
        int targetNamespace = treeView.getNamespaceId("named");
        for (MappingTreeView.ClassMappingView type : treeView.getClasses()) {
            String[] stringArray;
            String[] stringArray2 = new String[]{type.getName(targetNamespace), type.getName(sourceNamespace)};
            IMappingBuilder.IClass addedClass = srgMappings.addClass(stringArray2);
            for (MappingTreeView.FieldMappingView field : type.getFields()) {
                stringArray = new String[]{field.getName(sourceNamespace), field.getName(targetNamespace)};
                addedClass.field(stringArray);
            }
            for (MappingTreeView.MethodMappingView method : type.getMethods()) {
                stringArray = new String[]{method.getName(sourceNamespace), method.getName(targetNamespace)};
                addedClass.method(method.getDesc(sourceNamespace), stringArray);
            }
        }
        srgMappings.build().write(Path_utilsKt.getAsPath((FileSystemLocationProperty)((FileSystemLocationProperty)this.getSrg())), IMappingFile.Format.SRG);
    }
}

