/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.forge.mappings;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.msrandom.minecraftcodev.forge.accesswidener.ForgeAccessTransformerResolutionRuleKt;
import net.msrandom.minecraftcodev.remapper.ExtraFileRemapper;
import org.cadixdev.at.AccessTransformSet;
import org.cadixdev.at.io.AccessTransformFormats;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0096\u0002\u00a8\u0006\r"}, d2={"Lnet/msrandom/minecraftcodev/forge/mappings/AccessTransformerRemapper;", "Lnet/msrandom/minecraftcodev/remapper/ExtraFileRemapper;", "<init>", "()V", "invoke", "", "mappings", "Lnet/fabricmc/mappingio/tree/MappingTreeView;", "fileSystem", "Ljava/nio/file/FileSystem;", "sourceNamespace", "", "targetNamespace", "minecraft-codev-forge"})
public final class AccessTransformerRemapper
implements ExtraFileRemapper {
    public void invoke(@NotNull MappingTreeView mappings, @NotNull FileSystem fileSystem, @NotNull String sourceNamespace, @NotNull String targetNamespace) {
        Intrinsics.checkNotNullParameter((Object)mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)sourceNamespace, (String)"sourceNamespace");
        Intrinsics.checkNotNullParameter((Object)targetNamespace, (String)"targetNamespace");
        int sourceNamespaceId = mappings.getNamespaceId(sourceNamespace);
        int targetNamespaceId = mappings.getNamespaceId(targetNamespace);
        for (Path path : ForgeAccessTransformerResolutionRuleKt.findAccessTransformers(fileSystem)) {
            MappingSet mappingSet = MappingSet.create();
            for (MappingTreeView.ClassMappingView treeClass : mappings.getClasses()) {
                String name;
                String className;
                if (treeClass.getName(sourceNamespaceId) == null) continue;
                ClassMapping mapping = mappingSet.getOrCreateClassMapping(className);
                if (treeClass.getName(targetNamespaceId) != null) {
                    String it;
                    boolean bl = false;
                    mapping.setDeobfuscatedName(it);
                }
                for (MappingTreeView.FieldMappingView field : treeClass.getFields()) {
                    if (field.getName(sourceNamespaceId) == null) continue;
                    String descriptor = field.getDesc(sourceNamespaceId);
                    FieldMapping fieldMapping = descriptor == null ? mapping.getOrCreateFieldMapping(name) : mapping.getOrCreateFieldMapping(name, descriptor);
                    fieldMapping.setDeobfuscatedName(field.getName(targetNamespaceId));
                }
                for (MappingTreeView.MethodMappingView method : treeClass.getMethods()) {
                    if (method.getName(sourceNamespaceId) == null) continue;
                    MethodMapping methodMapping = mapping.getOrCreateMethodMapping(name, method.getDesc(sourceNamespaceId));
                    if (method.getName(targetNamespaceId) != null) {
                        String it;
                        boolean bl = false;
                        methodMapping.setDeobfuscatedName(it);
                    }
                    for (MappingTreeView.MethodArgMappingView argument : method.getArgs()) {
                        methodMapping.getOrCreateParameterMapping(argument.getArgPosition()).setDeobfuscatedName(argument.getName(targetNamespaceId));
                    }
                }
            }
            AccessTransformSet accessTransformer = AccessTransformFormats.FML.read(path);
            Files.delete(path);
            AccessTransformFormats.FML.write(path, accessTransformer.remap(mappingSet));
        }
    }
}

