/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.decompiler;

import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.decompiler.SingleFileSaver;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a8\u0006\u000b"}, d2={"Lnet/msrandom/minecraftcodev/decompiler/SourcesGenerator;", "", "<init>", "()V", "decompile", "", "input", "Ljava/nio/file/Path;", "output", "classpath", "", "minecraft-codev-decompiler"})
public final class SourcesGenerator {
    @NotNull
    public static final SourcesGenerator INSTANCE = new SourcesGenerator();

    private SourcesGenerator() {
    }

    public final void decompile(@NotNull Path input, @NotNull Path output, @NotNull Collection<? extends Path> classpath) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        BaseDecompiler decompiler2 = new BaseDecompiler((IResultSaver)new SingleFileSaver(output.toFile()), MapsKt.mapOf((Pair)TuplesKt.to((Object)"bytecode-source-mapping", (Object)"1")), new IFernflowerLogger(){

            public void writeMessage(String message, IFernflowerLogger.Severity severity) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            }

            public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            }
        });
        for (Path path : classpath) {
            decompiler2.addLibrary(path.toFile());
        }
        decompiler2.addSource(input.toFile());
        decompiler2.decompileContext();
    }
}

