/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.utils;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a4\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007*\u00020\u00032\u001d\u0010\b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0004\u0012\u0002H\u00070\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\r\u001a\u00020\u0003*\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u0010\u00a8\u0006\u0011"}, d2={"zipFileSystem", "Ljava/nio/file/FileSystem;", "path", "Ljava/nio/file/Path;", "create", "", "walk", "T", "action", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "Lkotlin/ExtensionFunctionType;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toPath", "Lorg/gradle/api/file/FileSystemLocation;", "getAsPath", "Lorg/gradle/api/file/FileSystemLocationProperty;", "minecraft-codev-core"})
public final class Path_utilsKt {
    @NotNull
    public static final FileSystem zipFileSystem(@NotNull Path path, boolean create) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Map env = MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)String.valueOf(create)));
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            try {
                FileSystem fileSystem = provider.newFileSystem(path, env);
                Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"newFileSystem(...)");
                return fileSystem;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new ProviderNotFoundException("Provider not found");
    }

    public static /* synthetic */ FileSystem zipFileSystem$default(Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Path_utilsKt.zipFileSystem(path, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T walk(@NotNull Path $this$walk, @NotNull Function1<? super Sequence<? extends Path>, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$walk, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable autoCloseable = Files.walk($this$walk, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            object = action.invoke((Object)StreamsKt.asSequence((Stream)it));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (T)object;
    }

    @NotNull
    public static final Path toPath(@NotNull FileSystemLocation $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        Path path = $this$toPath.getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @NotNull
    public static final Path getAsPath(@NotNull FileSystemLocationProperty<?> $this$getAsPath) {
        Intrinsics.checkNotNullParameter($this$getAsPath, (String)"<this>");
        Path path = ((File)$this$getAsPath.getAsFile().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }
}

