/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.utils;

import com.google.common.hash.HashCode;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.msrandom.minecraftcodev.core.utils.HashKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a2\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f\u00b2\u0006\n\u0010\u0010\u001a\u00020\u0011X\u008a\u0084\u0002"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "downloadTo", "", "uri", "Ljava/net/URI;", "output", "Ljava/nio/file/Path;", "download", "sha1", "", "isOffline", "", "alwaysRefresh", "minecraft-codev-core", "outputHash", "Lcom/google/common/hash/HashCode;"})
public final class DownloadKt {
    private static final Logger logger = LoggerFactory.getLogger((String)"Download");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void downloadTo(URI uri, Path output) {
        logger.info("Downloading " + uri);
        PathsKt.createParentDirectories((Path)output, (FileAttribute[])new FileAttribute[0]);
        Closeable closeable = uri.toURL().openStream();
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(output, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable2 = outputStream;
            int n = 8192;
            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream output2 = (BufferedOutputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)input);
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output2, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void download(@NotNull URI uri, @Nullable String sha1, @NotNull Path output, boolean isOffline, boolean alwaysRefresh) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(output, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            if (isOffline) {
                throw new GradleException("Trying to download or access " + uri + " in offline mode");
            }
            DownloadKt.downloadTo(uri, output);
            return;
        }
        Lazy outputHash$delegate = LazyKt.lazy(() -> DownloadKt.download$lambda$2(output));
        if (sha1 != null) {
            if (!alwaysRefresh && Intrinsics.areEqual((Object)DownloadKt.download$lambda$3((Lazy<? extends HashCode>)outputHash$delegate), (Object)HashCode.fromString((String)sha1))) {
                logger.debug("Using cached file {} since metadata checksum {} matches", (Object)output, (Object)sha1);
                return;
            }
            if (isOffline) {
                throw new GradleException("Cached version of " + uri + " at " + output + " has mismatched hash " + DownloadKt.download$lambda$3((Lazy<? extends HashCode>)outputHash$delegate) + ", expected " + sha1 + ", can not re-download in offline mode");
            }
            DownloadKt.downloadTo(uri, output);
            return;
        }
        if (isOffline) {
            logger.debug("Using cached file {} without extra checksum validation due to being in offline mode", (Object)output);
            return;
        }
        if (!alwaysRefresh) {
            String hash;
            String string;
            URLConnection uRLConnection = uri.toURL().openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("HEAD");
            String sha1Header = connection.getHeaderField("X-Checksum-Sha1");
            if (sha1Header != null) {
                string = sha1Header;
            } else {
                String etag = connection.getHeaderField("ETag");
                if (etag != null && StringsKt.startsWith$default((String)etag, (String)"{SHA1{", (boolean)false, (int)2, null)) {
                    String string2 = etag.substring(6, etag.length() - 2);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = hash = null;
                }
            }
            if (hash != null && Intrinsics.areEqual((Object)DownloadKt.download$lambda$3((Lazy<? extends HashCode>)outputHash$delegate), (Object)HashCode.fromString((String)hash))) {
                logger.debug("Using cached file {} since server-reported checksum {} matches", (Object)output, (Object)hash);
                return;
            }
        }
        DownloadKt.downloadTo(uri, output);
    }

    public static /* synthetic */ void download$default(URI uRI, String string, Path path, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        DownloadKt.download(uRI, string, path, bl, bl2);
    }

    private static final HashCode download$lambda$2(Path $output) {
        return HashKt.hashFileSha1($output);
    }

    private static final HashCode download$lambda$3(Lazy<? extends HashCode> $outputHash$delegate) {
        Lazy<? extends HashCode> lazy = $outputHash$delegate;
        return (HashCode)lazy.getValue();
    }
}

