/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.resolve;

import java.net.URI;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftDownloadVariant;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.utils.DownloadKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a(\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u001a0\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a0\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"downloadFullMinecraftClient", "Ljava/nio/file/Path;", "cacheDirectory", "metadata", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftVersionMetadata;", "isOffline", "", "downloadMinecraftFile", "variant", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftDownloadVariant;", "version", "", "downloadName", "variantDownload", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftVersionMetadata$Download;", "minecraftFilePath", "kotlin.jvm.PlatformType", "minecraft-codev-core"})
public final class GetMinecraftFileKt {
    @NotNull
    public static final Path downloadFullMinecraftClient(@NotNull Path cacheDirectory, @NotNull MinecraftVersionMetadata metadata, boolean isOffline) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        return GetMinecraftFileKt.downloadMinecraftFile(cacheDirectory, metadata.getId(), MinecraftDownloadVariant.Client.getDownload(), (MinecraftVersionMetadata.Download)MapsKt.getValue(metadata.getDownloads(), (Object)MinecraftDownloadVariant.Client.getDownload()), isOffline);
    }

    @Nullable
    public static final Path downloadMinecraftFile(@NotNull Path cacheDirectory, @NotNull MinecraftVersionMetadata metadata, @NotNull MinecraftDownloadVariant variant, boolean isOffline) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        MinecraftVersionMetadata.Download download = metadata.getDownloads().get(variant.getDownload());
        if (download != null) {
            MinecraftVersionMetadata.Download it = download;
            boolean bl = false;
            path = GetMinecraftFileKt.downloadMinecraftFile(cacheDirectory, metadata.getId(), variant.getDownload(), it, isOffline);
        } else {
            path = null;
        }
        return path;
    }

    private static final Path downloadMinecraftFile(Path cacheDirectory, String version2, String downloadName, MinecraftVersionMetadata.Download variantDownload, boolean isOffline) {
        Path downloadPath = GetMinecraftFileKt.minecraftFilePath(cacheDirectory, version2, downloadName, variantDownload);
        URI uRI = variantDownload.getUrl();
        String string = variantDownload.getSha1();
        Intrinsics.checkNotNull((Object)downloadPath);
        DownloadKt.download$default(uRI, string, downloadPath, isOffline, false, 16, null);
        return downloadPath;
    }

    private static final Path minecraftFilePath(Path cacheDirectory, String version2, String downloadName, MinecraftVersionMetadata.Download variantDownload) {
        Path path = cacheDirectory.resolve("download-cache").resolve(variantDownload.getSha1());
        String string = variantDownload.getUrl().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return path.resolve(downloadName + "-" + version2 + "." + StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null));
    }
}

