/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.task;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.msrandom.minecraftcodev.core.resolve.GetMinecraftFileKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftDownloadVariant;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionList;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.task.CachedMinecraftTask;
import net.msrandom.minecraftcodev.core.task.CachedMinecraftTaskKt;
import net.msrandom.minecraftcodev.core.task.MinecraftVersioned;
import net.msrandom.minecraftcodev.core.utils.CacheKt;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lnet/msrandom/minecraftcodev/core/task/ResolveMinecraftMappings;", "Lnet/msrandom/minecraftcodev/core/task/CachedMinecraftTask;", "Lnet/msrandom/minecraftcodev/core/task/MinecraftVersioned;", "<init>", "()V", "server", "Lorg/gradle/api/provider/Property;", "", "getServer", "()Lorg/gradle/api/provider/Property;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "download", "", "minecraft-codev-core"})
public abstract class ResolveMinecraftMappings
extends CachedMinecraftTask
implements MinecraftVersioned {
    public ResolveMinecraftMappings() {
        this.getOutput().convention(this.getProject().getLayout().file(this.getMinecraftVersion().zip((Provider)this.getServer(), new BiFunction(){

            public final File apply(String v, Boolean s) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                String variant = s != false ? "server" : "client";
                File file = this.getTemporaryDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getTemporaryDir(...)");
                return FilesKt.resolve((File)file, (String)("minecraft-" + variant + "-mappings-" + v + ".txt"));
            }
        })));
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getServer();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void download() {
        MinecraftVersionList versionList = CachedMinecraftTaskKt.versionList(this.getCacheParameters());
        Object object = this.getMinecraftVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        MinecraftVersionMetadata version2 = versionList.version((String)object);
        MinecraftDownloadVariant variant = (Boolean)this.getServer().get() != false ? MinecraftDownloadVariant.ServerMappings : MinecraftDownloadVariant.ClientMappings;
        Path output = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getOutput());
        Path path = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getCacheParameters().getDirectory());
        Object object2 = this.getCacheParameters().getIsOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Path path2 = GetMinecraftFileKt.downloadMinecraftFile(path, version2, variant, (Boolean)object2);
        if (path2 == null) {
            throw new IllegalArgumentException(version2.getId() + " does not have variant " + variant);
        }
        Path downloadPath = path2;
        Files.deleteIfExists(output);
        CacheKt.tryLink(output, downloadPath);
    }
}

