/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.task;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionList;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.resolve.VanillaSplittingStateKt;
import net.msrandom.minecraftcodev.core.task.CachedMinecraftTask;
import net.msrandom.minecraftcodev.core.task.CachedMinecraftTaskKt;
import net.msrandom.minecraftcodev.core.task.MinecraftVersioned;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lnet/msrandom/minecraftcodev/core/task/ResolveMinecraftCommon;", "Lnet/msrandom/minecraftcodev/core/task/CachedMinecraftTask;", "Lnet/msrandom/minecraftcodev/core/task/MinecraftVersioned;", "<init>", "()V", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "extract", "", "minecraft-codev-core"})
public abstract class ResolveMinecraftCommon
extends CachedMinecraftTask
implements MinecraftVersioned {
    public ResolveMinecraftCommon() {
        this.getOutput().convention(this.getProject().getLayout().file(this.getMinecraftVersion().map(new Transformer(){

            public final File transform(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                File file = this.getTemporaryDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getTemporaryDir(...)");
                return FilesKt.resolve((File)file, (String)("minecraft-common-" + it + ".jar"));
            }
        })));
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void extract() {
        MinecraftVersionList versionList = CachedMinecraftTaskKt.versionList(this.getCacheParameters());
        Object object = this.getMinecraftVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        MinecraftVersionMetadata version2 = versionList.version((String)object);
        Path path = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getCacheParameters().getDirectory());
        Object object2 = this.getCacheParameters().getIsOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        VanillaSplittingStateKt.setupCommon(path, version2, (Boolean)object2, Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getOutput()));
    }
}

