package net.msrandom.minecraftcodev.core.task

import org.gradle.api.java.archives.Manifest
import org.gradle.jvm.tasks.Jar

/**
 * To be invoked at execution time before the Jar task's primary action is executed.
 * Causes the [baseManifest] to be included as the base for the Jar's manifest with the explicit manifest being overlaid on top of it
 * @receiver The target Jar to include the manifest in
 * @param baseManifest The manifest to be included as the base
 */
fun Jar.mergeManifestFrom(baseManifest: Manifest?) {
    if (baseManifest == null) {
        return
    }

    val explicitManifest = replaceManifestFrom(baseManifest)

    manifest.from(explicitManifest)
}

fun Jar.mergeManifestFrom(manifestA: Manifest?, manifestB: Manifest?) {
    if (manifestA == null && manifestB == null) {
        return
    }

    if (manifestA == null) {
        return mergeManifestFrom(manifestB)
    } else if (manifestB == null) {
        return mergeManifestFrom(manifestA)
    }

    val explicitManifest = replaceManifestFrom(manifestA)

    manifest.from(manifestB)
    manifest.from(explicitManifest)
}

fun Jar.replaceManifestFrom(otherManifest: Manifest): Manifest? {
    val explicitManifest = manifest

    manifest = otherManifest.effectiveManifest

    return explicitManifest
}
