/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.utils;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"hashFile", "Lcom/google/common/hash/HashCode;", "file", "Ljava/nio/file/Path;", "function", "Lcom/google/common/hash/HashFunction;", "hashFileSha1", "checkHashSha1", "", "expectedHash", "", "minecraft-codev-core"})
public final class HashKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HashCode hashFile(Path file, HashFunction function) {
        Hasher hasher = function.newHasher();
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            long l = ByteStreams.copy((InputStream)it, (OutputStream)Funnels.asOutputStream((PrimitiveSink)((PrimitiveSink)hasher)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        HashCode hashCode = hasher.hash();
        Intrinsics.checkNotNullExpressionValue((Object)hashCode, (String)"hash(...)");
        return hashCode;
    }

    @NotNull
    public static final HashCode hashFile(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HashFunction hashFunction = Hashing.murmur3_32_fixed();
        Intrinsics.checkNotNullExpressionValue((Object)hashFunction, (String)"murmur3_32_fixed(...)");
        return HashKt.hashFile(file, hashFunction);
    }

    @NotNull
    public static final HashCode hashFileSha1(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HashFunction hashFunction = Hashing.sha1();
        Intrinsics.checkNotNullExpressionValue((Object)hashFunction, (String)"sha1(...)");
        return HashKt.hashFile(file, hashFunction);
    }

    public static final boolean checkHashSha1(@NotNull Path file, @NotNull String expectedHash) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expectedHash, (String)"expectedHash");
        return Intrinsics.areEqual((Object)HashKt.hashFileSha1(file), (Object)HashCode.fromString((String)expectedHash));
    }
}

