/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.resolve.bundled;

import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import net.msrandom.minecraftcodev.core.resolve.GetMinecraftFileKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.resolve.legacy.LegacyJarSplitter;
import net.msrandom.minecraftcodev.core.utils.CacheKt;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lnet/msrandom/minecraftcodev/core/resolve/bundled/BundledClientJarSplitter;", "", "<init>", "()V", "split", "Ljava/nio/file/Path;", "cacheDirectory", "metadata", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftVersionMetadata;", "server", "isOffline", "", "split$minecraft_codev_core", "minecraft-codev-core"})
public final class BundledClientJarSplitter {
    @NotNull
    public static final BundledClientJarSplitter INSTANCE = new BundledClientJarSplitter();

    private BundledClientJarSplitter() {
    }

    @NotNull
    public final Path split$minecraft_codev_core(@NotNull Path cacheDirectory, @NotNull MinecraftVersionMetadata metadata, @NotNull Path server, boolean isOffline) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Path client = GetMinecraftFileKt.downloadFullMinecraftClient(cacheDirectory, metadata, isOffline);
        Path outputClient = CacheKt.clientJarPath(cacheDirectory, metadata.getId());
        Path path = outputClient.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        LegacyJarSplitter.INSTANCE.useFileSystems(arg_0 -> BundledClientJarSplitter.split$lambda$2(client, server, outputClient, arg_0));
        return outputClient;
    }

    private static final Unit split$lambda$2$lambda$0(FileSystem $serverFs, FileSystem $newClientFs, Sequence $this$walk) {
        Intrinsics.checkNotNullParameter((Object)$this$walk, (String)"$this$walk");
        for (Path clientEntry : $this$walk) {
            Path path;
            String name = ((Object)clientEntry).toString();
            if (!StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null)) continue;
            Path serverEntry = $serverFs.getPath(name, new String[0]);
            Intrinsics.checkNotNull((Object)serverEntry);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.notExists(serverEntry, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            Path output = $newClientFs.getPath(name, new String[0]);
            Path path2 = output.getParent();
            if (path2 != null) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
            } else {
                path = null;
            }
            Path path4 = clientEntry;
            Intrinsics.checkNotNull((Object)output);
            Path path5 = output;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path4, path5, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
        return Unit.INSTANCE;
    }

    private static final Unit split$lambda$2$lambda$1(FileSystem $serverFs, FileSystem $newClientFs, Path path) {
        block6: {
            Path path2;
            Object object;
            String name;
            block5: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                name = ((Object)path).toString();
                Path path3 = $serverFs.getPath(name, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getPath(...)");
                Path path4 = path3;
                object = new LinkOption[]{};
                if (Files.notExists(path4, Arrays.copyOf(object, ((LinkOption[])object).length)) || StringsKt.contains$default((CharSequence)name, (CharSequence)"lang", (boolean)false, (int)2, null)) break block5;
                Path path5 = path.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"getParent(...)");
                if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)path5), (Object)"assets") || !StringsKt.startsWith$default((CharSequence)PathsKt.getName((Path)path), (char)'.', (boolean)false, (int)2, null)) break block6;
            }
            Path newPath = $newClientFs.getPath(name, new String[0]);
            Path path6 = newPath.getParent();
            if (path6 != null) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path7 = Files.createDirectories(path6, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                path2 = path7;
                Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"createDirectories(...)");
            } else {
                path2 = null;
            }
            object = path;
            Intrinsics.checkNotNull((Object)newPath);
            Path path8 = newPath;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, path8, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
        return Unit.INSTANCE;
    }

    private static final Unit split$lambda$2(Path $client, Path $server, Path $outputClient, Function1 handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        FileSystem fileSystem = Path_utilsKt.zipFileSystem$default($client, false, 2, null);
        handle.invoke((Object)fileSystem);
        FileSystem clientFs = fileSystem;
        FileSystem fileSystem2 = Path_utilsKt.zipFileSystem$default($server, false, 2, null);
        handle.invoke((Object)fileSystem2);
        FileSystem serverFs = fileSystem2;
        FileSystem fileSystem3 = Path_utilsKt.zipFileSystem($outputClient, true);
        handle.invoke((Object)fileSystem3);
        FileSystem newClientFs = fileSystem3;
        Path path = clientFs.getPath("/", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path_utilsKt.walk(path, arg_0 -> BundledClientJarSplitter.split$lambda$2$lambda$0(serverFs, newClientFs, arg_0));
        LegacyJarSplitter.INSTANCE.withAssets(clientFs, (Function1<? super Path, Unit>)((Function1)arg_0 -> BundledClientJarSplitter.split$lambda$2$lambda$1(serverFs, newClientFs, arg_0)));
        return Unit.INSTANCE;
    }
}

