/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.utils;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u001a4\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u00020\u00072\u001d\u0010\f\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\u0010\u0010\u001a\n\u0010\u0011\u001a\u00020\u0007*\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u0014\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0015"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "zipFileSystem", "Ljava/nio/file/FileSystem;", "file", "Ljava/nio/file/Path;", "create", "", "walk", "T", "action", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "Lkotlin/ExtensionFunctionType;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toPath", "Lorg/gradle/api/file/FileSystemLocation;", "getAsPath", "Lorg/gradle/api/file/FileSystemLocationProperty;", "minecraft-codev-core"})
public final class Path_utilsKt {
    private static final Logger logger = LoggerFactory.getLogger((String)"path-utils");

    @Blocking
    @NotNull
    public static final FileSystem zipFileSystem(@NotNull Path file, boolean create) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        URI uri = URI.create("jar:" + file.toUri());
        if (create) {
            FileSystem fileSystem = FileSystems.newFileSystem(uri, MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)"true")));
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"newFileSystem(...)");
            return fileSystem;
        }
        while (true) {
            try {
                FileSystem fileSystem = FileSystems.newFileSystem(uri, MapsKt.emptyMap());
                Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"newFileSystem(...)");
                return fileSystem;
            }
            catch (FileSystemAlreadyExistsException e) {
                logger.info("Couldn't acquire access to " + file + " file-system, waiting", (Throwable)e);
                Thread.sleep(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)));
                continue;
            }
            break;
        }
    }

    public static /* synthetic */ FileSystem zipFileSystem$default(Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Path_utilsKt.zipFileSystem(path, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T walk(@NotNull Path $this$walk, @NotNull Function1<? super Sequence<? extends Path>, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$walk, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable autoCloseable = Files.walk($this$walk, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            object = action.invoke((Object)StreamsKt.asSequence((Stream)it));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (T)object;
    }

    @NotNull
    public static final Path toPath(@NotNull FileSystemLocation $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        Path path = $this$toPath.getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @NotNull
    public static final Path getAsPath(@NotNull FileSystemLocationProperty<?> $this$getAsPath) {
        Intrinsics.checkNotNullParameter($this$getAsPath, (String)"<this>");
        Path path = ((File)$this$getAsPath.getAsFile().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }
}

