/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.task;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionList;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.resolve.VanillaSplittingStateKt;
import net.msrandom.minecraftcodev.core.task.CachedMinecraftTask;
import net.msrandom.minecraftcodev.core.task.CachedMinecraftTaskKt;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lnet/msrandom/minecraftcodev/core/task/ResolveMinecraftClient;", "Lnet/msrandom/minecraftcodev/core/task/CachedMinecraftTask;", "<init>", "()V", "version", "Lorg/gradle/api/provider/Property;", "", "getVersion", "()Lorg/gradle/api/provider/Property;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "extract", "", "minecraft-codev-core"})
public abstract class ResolveMinecraftClient
extends CachedMinecraftTask {
    public ResolveMinecraftClient() {
        this.getOutput().convention(this.getProject().getLayout().file(this.getVersion().map(arg_0 -> ResolveMinecraftClient._init_$lambda$1(arg_0 -> ResolveMinecraftClient._init_$lambda$0(this, arg_0), arg_0))));
    }

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void extract() {
        MinecraftVersionList versionList = CachedMinecraftTaskKt.versionList(this.getCacheParameters());
        Object object = this.getVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        MinecraftVersionMetadata version = versionList.version((String)object);
        Path path = ((File)this.getCacheParameters().getDirectory().getAsFile().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path path2 = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getOutput());
        Object object2 = this.getCacheParameters().getIsOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        VanillaSplittingStateKt.setupClient(path, path2, version, (Boolean)object2);
    }

    private static final File _init_$lambda$0(ResolveMinecraftClient this$0, String it) {
        File file = this$0.getTemporaryDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getTemporaryDir(...)");
        return FilesKt.resolve((File)file, (String)("minecraft-client-" + it + ".jar"));
    }

    private static final File _init_$lambda$1(Function1 $tmp0, Object in) {
        return (File)$tmp0.invoke(in);
    }
}

