/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.resolve;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.msrandom.minecraftcodev.core.MinecraftOperatingSystemAttributeKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftMarkerKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.resolve.ServerExtractionResult;
import net.msrandom.minecraftcodev.core.resolve.ServerExtractionStateKt;
import net.msrandom.minecraftcodev.core.resolve.bundled.BundledClientJarSplitter;
import net.msrandom.minecraftcodev.core.resolve.legacy.LegacyJarSplitter;
import net.msrandom.minecraftcodev.core.utils.Build_utilsKt;
import net.msrandom.minecraftcodev.core.utils.CacheKt;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0000\u001a(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0015"}, d2={"setupCommon", "", "", "cacheDirectory", "Ljava/nio/file/Path;", "metadata", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftVersionMetadata;", "isOffline", "", "output", "setupClient", "", "getAllDependencies", "", "osMatches", "os", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftVersionMetadata$Rule$OperatingSystem;", "rulesMatch", "rules", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftVersionMetadata$Rule;", "getClientDependencies", "minecraft-codev-core"})
@SourceDebugExtension(value={"SMAP\nVanillaSplittingState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VanillaSplittingState.kt\nnet/msrandom/minecraftcodev/core/resolve/VanillaSplittingStateKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n774#2:121\n865#2,2:122\n1557#2:124\n1628#2,3:125\n*S KotlinDebug\n*F\n+ 1 VanillaSplittingState.kt\nnet/msrandom/minecraftcodev/core/resolve/VanillaSplittingStateKt\n*L\n75#1:121\n75#1:122,2\n75#1:124\n75#1:125,3\n*E\n"})
public final class VanillaSplittingStateKt {
    @NotNull
    public static final Iterable<String> setupCommon(@NotNull Path cacheDirectory, @NotNull MinecraftVersionMetadata metadata, boolean isOffline, @Nullable Path output) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Path path = output;
        if (path != null) {
            Files.deleteIfExists(path);
        }
        ServerExtractionResult serverExtractionResult = ServerExtractionStateKt.getExtractionState(cacheDirectory, metadata, isOffline);
        Intrinsics.checkNotNull((Object)serverExtractionResult);
        ServerExtractionResult serverExtractionResult2 = serverExtractionResult;
        Path extractedServer = serverExtractionResult2.component1();
        boolean isBundled = serverExtractionResult2.component2();
        List<String> libraries = serverExtractionResult2.component3();
        if (isBundled) {
            Path path2 = output;
            if (path2 != null) {
                CacheKt.tryLink(path2, extractedServer);
            }
            iterable = libraries;
        } else {
            Path commonJarPath = CacheKt.commonJarPath(cacheDirectory, metadata.getId());
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(commonJarPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.notExists(CacheKt.clientJarPath(cacheDirectory, metadata.getId()), Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    LegacyJarSplitter.INSTANCE.split$minecraft_codev_core(cacheDirectory, metadata, extractedServer, isOffline);
                }
            }
            Path path3 = output;
            if (path3 != null) {
                CacheKt.tryLink(path3, commonJarPath);
            }
            iterable = CollectionsKt.plus((Collection)libraries, (Object)"net.msrandom:side-annotations:1.0.1");
        }
        return iterable;
    }

    public static /* synthetic */ Iterable setupCommon$default(Path path, MinecraftVersionMetadata minecraftVersionMetadata, boolean bl, Path path2, int n, Object object) {
        if ((n & 8) != 0) {
            path2 = null;
        }
        return VanillaSplittingStateKt.setupCommon(path, minecraftVersionMetadata, bl, path2);
    }

    public static final void setupClient(@NotNull Path cacheDirectory, @NotNull Path output, @NotNull MinecraftVersionMetadata metadata, boolean isOffline) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Files.deleteIfExists(output);
        Path clientJarPath = CacheKt.clientJarPath(cacheDirectory, metadata.getId());
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(clientJarPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            CacheKt.tryLink(output, clientJarPath);
            return;
        }
        ServerExtractionResult serverExtractionResult = ServerExtractionStateKt.getExtractionState(cacheDirectory, metadata, isOffline);
        Intrinsics.checkNotNull((Object)serverExtractionResult);
        ServerExtractionResult serverExtractionResult2 = serverExtractionResult;
        Path extractedServer = serverExtractionResult2.component1();
        boolean isBundled = serverExtractionResult2.component2();
        Path path = isBundled ? BundledClientJarSplitter.INSTANCE.split$minecraft_codev_core(cacheDirectory, metadata, extractedServer, isOffline) : LegacyJarSplitter.INSTANCE.split$minecraft_codev_core(cacheDirectory, metadata, extractedServer, isOffline).getClient();
        MinecraftMarkerKt.addMinecraftMarker(clientJarPath);
        CacheKt.tryLink(output, clientJarPath);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getAllDependencies(@NotNull MinecraftVersionMetadata metadata) {
        void $this$mapTo$iv$iv;
        MinecraftVersionMetadata.Library it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Iterable $this$filter$iv = metadata.getLibraries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MinecraftVersionMetadata.Library)element$iv$iv;
            boolean bl = false;
            if (!VanillaSplittingStateKt.rulesMatch(it.getRules())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MinecraftVersionMetadata.Library)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName().toString());
        }
        return (List)destination$iv$iv;
    }

    private static final boolean osMatches(MinecraftVersionMetadata.Rule.OperatingSystem os) {
        if (os.getName() != null && !Intrinsics.areEqual((Object)os.getName(), (Object)MinecraftOperatingSystemAttributeKt.operatingSystemName())) {
            return false;
        }
        if (os.getVersion() != null) {
            CharSequence charSequence = Build_utilsKt.osVersion();
            if (!new Regex(os.getVersion()).matches(charSequence)) {
                return false;
            }
        }
        return os.getArch() == null || Intrinsics.areEqual((Object)os.getArch(), (Object)SystemUtils.OS_ARCH);
    }

    public static final boolean rulesMatch(@NotNull List<MinecraftVersionMetadata.Rule> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        if (rules.isEmpty()) {
            return true;
        }
        boolean allowed = false;
        for (MinecraftVersionMetadata.Rule rule : rules) {
            if (rule.getAction() == MinecraftVersionMetadata.RuleAction.Allow) {
                if (rule.getOs() != null && !VanillaSplittingStateKt.osMatches(rule.getOs())) continue;
                allowed = true;
                continue;
            }
            if (rule.getOs() != null && !VanillaSplittingStateKt.osMatches(rule.getOs())) continue;
            allowed = false;
        }
        return allowed;
    }

    @NotNull
    public static final Iterable<String> getClientDependencies(@NotNull Path cacheDirectory, @NotNull MinecraftVersionMetadata metadata, boolean isOffline) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        ServerExtractionResult serverExtractionResult = ServerExtractionStateKt.getExtractionState(cacheDirectory, metadata, isOffline);
        Intrinsics.checkNotNull((Object)serverExtractionResult);
        List<String> serverLibraries = serverExtractionResult.component3();
        return CollectionsKt.minus((Iterable)VanillaSplittingStateKt.getAllDependencies(metadata), (Iterable)CollectionsKt.toSet((Iterable)serverLibraries));
    }
}

