/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.resolve;

import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.msrandom.minecraftcodev.core.resolve.GetMinecraftFileKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftDownloadVariant;
import net.msrandom.minecraftcodev.core.resolve.MinecraftMarkerKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.resolve.ServerExtractionResult;
import net.msrandom.minecraftcodev.core.resolve.bundled.ServerExtractor;
import net.msrandom.minecraftcodev.core.resolve.legacy.ServerFixer;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"getExtractionState", "Lnet/msrandom/minecraftcodev/core/resolve/ServerExtractionResult;", "cacheDirectory", "Ljava/nio/file/Path;", "manifest", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftVersionMetadata;", "isOffline", "", "minecraft-codev-core"})
public final class ServerExtractionStateKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final ServerExtractionResult getExtractionState(@NotNull Path cacheDirectory, @NotNull MinecraftVersionMetadata manifest, boolean isOffline) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Path extractedServerData = cacheDirectory.resolve("extracted-servers").resolve(manifest.getId());
        Path extractedJar = extractedServerData.resolve("server.jar");
        Path libraries = extractedServerData.resolve("libraries.txt");
        Path bundledMark = extractedServerData.resolve("bundle");
        Intrinsics.checkNotNull((Object)extractedJar);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(extractedJar, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Intrinsics.checkNotNull((Object)libraries);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(libraries, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Path path = libraries;
                List<String> list = Files.readAllLines(path, Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                List<String> commonLibraries = list;
                Intrinsics.checkNotNull((Object)bundledMark);
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                boolean isBundled = Files.exists(bundledMark, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length));
                return new ServerExtractionResult(extractedJar, isBundled, commonLibraries);
            }
        }
        Path path = GetMinecraftFileKt.downloadMinecraftFile(cacheDirectory, manifest, MinecraftDownloadVariant.Server, isOffline);
        if (path == null) {
            return null;
        }
        Path serverJar = path;
        Path temporaryServer = Files.createTempFile("server-", ".tmp.jar", new FileAttribute[0]);
        List<String> commonLibraries = null;
        boolean isBundled = false;
        Object object2 = Path_utilsKt.zipFileSystem$default(serverJar, false, 2, null);
        Object object3 = null;
        try {
            FileSystem serverFs = (FileSystem)object2;
            boolean bl = false;
            Path librariesPath = serverFs.getPath("META-INF/libraries.list", new String[0]);
            Intrinsics.checkNotNull((Object)librariesPath);
            LinkOption[] linkOptionArray4 = new LinkOption[]{};
            if (Files.exists(librariesPath, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) {
                isBundled = true;
                String string = manifest.getId();
                Intrinsics.checkNotNull((Object)temporaryServer);
                commonLibraries = ServerExtractor.INSTANCE.extract(string, temporaryServer, serverFs, librariesPath);
            } else {
                isBundled = false;
                Path path2 = serverJar;
                Intrinsics.checkNotNull((Object)temporaryServer);
                Path path3 = temporaryServer;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path3, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                commonLibraries = ServerFixer.INSTANCE.removeLibraries(manifest, temporaryServer, serverFs, GetMinecraftFileKt.downloadMinecraftClient(cacheDirectory, manifest, isOffline));
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        Intrinsics.checkNotNull((Object)extractedServerData);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(extractedServerData, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        object2 = temporaryServer;
        object3 = extractedJar;
        object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object2, (Path)object3, Arrays.copyOf(object, ((CopyOption[])object).length)), (String)"copy(...)");
        Intrinsics.checkNotNull((Object)libraries);
        object2 = libraries;
        object3 = commonLibraries;
        OpenOption[] openOptionArray = new OpenOption[]{};
        object = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write((Path)object2, (Iterable<? extends CharSequence>)object3, (Charset)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
        if (isBundled) {
            Files.createFile(bundledMark, new FileAttribute[0]);
        }
        MinecraftMarkerKt.addMinecraftMarker(extractedJar);
        return new ServerExtractionResult(extractedJar, isBundled, commonLibraries);
    }
}

