/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.stubs;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.msrandom.stubs.StubGenerator;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0007R \u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lnet/msrandom/stubs/GenerateStubApi;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "classpaths", "Lorg/gradle/api/provider/ListProperty;", "", "Lnet/msrandom/stubs/GenerateStubApi$ResolvedArtifact;", "getClasspaths", "()Lorg/gradle/api/provider/ListProperty;", "excludes", "", "getExcludes", "apiFileName", "Lorg/gradle/api/provider/Property;", "getApiFileName", "()Lorg/gradle/api/provider/Property;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "generateStub", "", "ResolvedArtifact", "classpath-api-stubs"})
public abstract class GenerateStubApi
extends DefaultTask {
    public GenerateStubApi() {
        this.getApiFileName().convention((Object)"api-stub.jar");
        this.getOutputDirectory().convention(this.getProject().getLayout().dir(this.getProject().provider(() -> GenerateStubApi._init_$lambda$0(this))));
    }

    @Nested
    @NotNull
    public abstract ListProperty<List<ResolvedArtifact>> getClasspaths();

    @Input
    @NotNull
    public abstract ListProperty<String> getExcludes();

    @Input
    @NotNull
    public abstract Property<String> getApiFileName();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @TaskAction
    public final void generateStub() {
        Path outputDirectory = ((File)this.getOutputDirectory().getAsFile().get()).toPath();
        Path apiFile = outputDirectory.resolve((String)this.getApiFileName().get());
        Object object = this.getClasspaths().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable iterable = (Iterable)object;
        Object object2 = this.getExcludes().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        List list = (List)object2;
        Intrinsics.checkNotNull((Object)apiFile);
        List<ResolvedArtifact> extras = StubGenerator.INSTANCE.generateStub(iterable, list, apiFile);
        for (ResolvedArtifact artifact : extras) {
            Path path;
            Path path2;
            String string = ((ComponentIdentifier)artifact.getId().get()).getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            Path directory = outputDirectory.resolve(StringsKt.replace$default((String)string, (char)':', (char)'_', (boolean)false, (int)4, null));
            Intrinsics.checkNotNull((Object)directory);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(directory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            File path3 = (File)artifact.getFile().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)path3.toPath(), (String)"toPath(...)");
            Intrinsics.checkNotNullExpressionValue((Object)directory.resolve(path3.getName()), (String)"resolve(...)");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
    }

    private static final File _init_$lambda$0(GenerateStubApi this$0) {
        return this$0.getTemporaryDir();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lnet/msrandom/stubs/GenerateStubApi$ResolvedArtifact;", "", "id", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "getId", "()Lorg/gradle/api/provider/Property;", "file", "Lorg/gradle/api/file/RegularFileProperty;", "getFile", "()Lorg/gradle/api/file/RegularFileProperty;", "classpath-api-stubs"})
    public static interface ResolvedArtifact {
        @Optional
        @Input
        @NotNull
        public Property<ComponentIdentifier> getId();

        @CompileClasspath
        @InputFile
        @NotNull
        public RegularFileProperty getFile();
    }
}

