/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.stubs;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.msrandom.stubs.StubGenerator;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0007R \u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00058'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lnet/msrandom/stubs/GenerateStubApi;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "classpaths", "Lorg/gradle/api/provider/ListProperty;", "", "Lnet/msrandom/stubs/GenerateStubApi$ResolvedArtifact;", "getClasspaths", "()Lorg/gradle/api/provider/ListProperty;", "excludes", "", "getExcludes", "apiFileName", "Lorg/gradle/api/provider/Property;", "getApiFileName", "()Lorg/gradle/api/provider/Property;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "generateStub", "", "ResolvedArtifact", "classpath-api-stubs"})
public abstract class GenerateStubApi
extends DefaultTask {
    public GenerateStubApi() {
        this.getApiFileName().convention((Object)"api-stub.jar");
        this.getOutputDirectory().convention(this.getProject().getLayout().dir(this.getProject().provider(new Callable(){

            public final File call() {
                return this.getTemporaryDir();
            }
        })));
    }

    @Nested
    @NotNull
    public abstract ListProperty<List<ResolvedArtifact>> getClasspaths();

    @Input
    @NotNull
    public abstract ListProperty<String> getExcludes();

    @Input
    @NotNull
    public abstract Property<String> getApiFileName();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @TaskAction
    public final void generateStub() {
        Path outputDirectory = ((File)this.getOutputDirectory().getAsFile().get()).toPath();
        Intrinsics.checkNotNull((Object)outputDirectory);
        PathsKt.deleteRecursively((Path)outputDirectory);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(outputDirectory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path apiFile = outputDirectory.resolve((String)this.getApiFileName().get());
        Object object = this.getClasspaths().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable iterable = (Iterable)object;
        Object object2 = this.getExcludes().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        List list = (List)object2;
        Intrinsics.checkNotNull((Object)apiFile);
        List<ResolvedArtifact> extras = StubGenerator.INSTANCE.generateStub(iterable, list, apiFile);
        for (ResolvedArtifact artifact : extras) {
            Path path;
            Path path2;
            Object object3 = artifact.getComponentId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            Path directory = outputDirectory.resolve(StringsKt.replace$default((String)((String)object3), (char)':', (char)'_', (boolean)false, (int)4, null));
            Intrinsics.checkNotNull((Object)directory);
            FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(directory, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createDirectories(...)");
            Object object4 = artifact.getFile().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            File path3 = (File)object4;
            Intrinsics.checkNotNullExpressionValue((Object)path3.toPath(), (String)"toPath(...)");
            Intrinsics.checkNotNullExpressionValue((Object)directory.resolve(path3.getName()), (String)"resolve(...)");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00038'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00038'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00108'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lnet/msrandom/stubs/GenerateStubApi$ResolvedArtifact;", "", "componentId", "Lorg/gradle/api/provider/Property;", "", "getComponentId", "()Lorg/gradle/api/provider/Property;", "type", "Lnet/msrandom/stubs/GenerateStubApi$ResolvedArtifact$Type;", "getType", "moduleVersion", "getModuleVersion", "moduleId", "Lorg/gradle/api/artifacts/ModuleIdentifier;", "getModuleId", "file", "Lorg/gradle/api/file/RegularFileProperty;", "getFile", "()Lorg/gradle/api/file/RegularFileProperty;", "setComponent", "", "component", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Type", "classpath-api-stubs"})
    public static interface ResolvedArtifact {
        @Optional
        @Input
        @NotNull
        public Property<String> getComponentId();

        @Optional
        @Input
        @NotNull
        public Property<Type> getType();

        @Optional
        @Input
        @NotNull
        public Property<String> getModuleVersion();

        @Optional
        @Input
        @NotNull
        public Property<ModuleIdentifier> getModuleId();

        @CompileClasspath
        @InputFile
        @NotNull
        public RegularFileProperty getFile();

        default public void setComponent(@NotNull ComponentIdentifier component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.getComponentId().set((Object)component.toString());
            ComponentIdentifier componentIdentifier = component;
            if (componentIdentifier instanceof ModuleComponentIdentifier) {
                this.getType().set((Object)Type.Module);
                this.getModuleId().set((Object)((ModuleComponentIdentifier)component).getModuleIdentifier());
                this.getModuleVersion().set((Object)((ModuleComponentIdentifier)component).getVersion());
            } else if (componentIdentifier instanceof ProjectComponentIdentifier) {
                this.getType().set((Object)Type.Project);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/msrandom/stubs/GenerateStubApi$ResolvedArtifact$Type;", "", "<init>", "(Ljava/lang/String;I)V", "Module", "Project", "classpath-api-stubs"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type Module = new Type();
            public static final /* enum */ Type Project = new Type();
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = typeArray = new Type[]{Type.Module, Type.Project};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

