/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.stubs.signature;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.msrandom.stubs.signature.ClassNameSegment;
import net.msrandom.stubs.signature.TypeArgument;
import net.msrandom.stubs.signature.TypeSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.signature.SignatureVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/msrandom/stubs/signature/TypeSignatureVisitor;", "Lorg/objectweb/asm/signature/SignatureVisitor;", "api", "", "callback", "Lkotlin/Function1;", "Lnet/msrandom/stubs/signature/TypeSignature;", "", "<init>", "(ILkotlin/jvm/functions/Function1;)V", "baseClassSegment", "Lnet/msrandom/stubs/signature/ClassNameSegment;", "innerClassSegments", "", "currentClassName", "", "isInnerClass", "", "typeArguments", "Lnet/msrandom/stubs/signature/TypeArgument;", "visitBaseType", "descriptor", "", "visitArrayType", "visitTypeVariable", "name", "visitClassType", "visitInnerClassType", "visitTypeArgument", "wildcard", "visitEnd", "classpath-api-stubs"})
public final class TypeSignatureVisitor
extends SignatureVisitor {
    @NotNull
    private final Function1<TypeSignature, Unit> callback;
    @Nullable
    private ClassNameSegment baseClassSegment;
    @NotNull
    private List<ClassNameSegment> innerClassSegments;
    @Nullable
    private String currentClassName;
    private boolean isInnerClass;
    @NotNull
    private List<TypeArgument> typeArguments;

    public TypeSignatureVisitor(int api, @NotNull Function1<? super TypeSignature, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        super(api);
        this.callback = callback;
        this.innerClassSegments = new ArrayList();
        this.typeArguments = new ArrayList();
    }

    public void visitBaseType(char descriptor) {
        this.callback.invoke((Object)new TypeSignature.Primitive(descriptor));
    }

    @NotNull
    public TypeSignatureVisitor visitArrayType() {
        return new TypeSignatureVisitor(this.api, (Function1<? super TypeSignature, Unit>)((Function1)arg_0 -> TypeSignatureVisitor.visitArrayType$lambda$0(this, arg_0)));
    }

    public void visitTypeVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.callback.invoke((Object)new TypeSignature.Reference.TypeVariable(name));
    }

    public void visitClassType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.currentClassName = name;
    }

    public void visitInnerClassType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.isInnerClass) {
            String string = this.currentClassName;
            Intrinsics.checkNotNull((Object)string);
            this.baseClassSegment = new ClassNameSegment(string, CollectionsKt.toList((Iterable)this.typeArguments));
        } else if (this.currentClassName != null) {
            String string = this.currentClassName;
            Intrinsics.checkNotNull((Object)string);
            this.innerClassSegments.add(new ClassNameSegment(string, CollectionsKt.toList((Iterable)this.typeArguments)));
        }
        this.typeArguments.clear();
        this.currentClassName = name;
        this.isInnerClass = true;
    }

    public void visitTypeArgument() {
        this.typeArguments.add(TypeArgument.Unbounded.INSTANCE);
    }

    @NotNull
    public TypeSignatureVisitor visitTypeArgument(char wildcard) {
        return new TypeSignatureVisitor(this.api, (Function1<? super TypeSignature, Unit>)((Function1)arg_0 -> TypeSignatureVisitor.visitTypeArgument$lambda$1(this, wildcard, arg_0)));
    }

    public void visitEnd() {
        if (this.isInnerClass) {
            String string = this.currentClassName;
            Intrinsics.checkNotNull((Object)string);
            this.innerClassSegments.add(new ClassNameSegment(string, CollectionsKt.toList((Iterable)this.typeArguments)));
        } else if (this.currentClassName != null) {
            String string = this.currentClassName;
            Intrinsics.checkNotNull((Object)string);
            this.baseClassSegment = new ClassNameSegment(string, CollectionsKt.toList((Iterable)this.typeArguments));
        }
        ClassNameSegment classNameSegment = this.baseClassSegment;
        Intrinsics.checkNotNull((Object)classNameSegment);
        this.callback.invoke((Object)new TypeSignature.Reference.Class(classNameSegment, this.innerClassSegments));
    }

    private static final Unit visitArrayType$lambda$0(TypeSignatureVisitor this$0, TypeSignature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.callback.invoke((Object)new TypeSignature.Reference.Array(it));
        return Unit.INSTANCE;
    }

    private static final Unit visitTypeArgument$lambda$1(TypeSignatureVisitor this$0, char $wildcard, TypeSignature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.typeArguments.add(new TypeArgument.Bounded(it, TypeArgument.Bounded.Variance.Companion.fromCharacter($wildcard)));
        return Unit.INSTANCE;
    }
}

