/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srgutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.InternalUtils;

public interface INamedMappingFile {
    public static INamedMappingFile load(File path) throws IOException {
        try (FileInputStream in = new FileInputStream(path);){
            if (path.getName().endsWith(".gz")) {
                INamedMappingFile iNamedMappingFile = INamedMappingFile.load(new GZIPInputStream(in));
                return iNamedMappingFile;
            }
            INamedMappingFile iNamedMappingFile = INamedMappingFile.load(in);
            return iNamedMappingFile;
        }
    }

    public static INamedMappingFile load(InputStream in) throws IOException {
        return InternalUtils.loadNamed(in);
    }

    public List<String> getNames();

    public IMappingFile getMap(String var1, String var2);

    default public void write(Path path, IMappingFile.Format format) throws IOException {
        this.write(path, format, this.getNames().toArray(new String[this.getNames().size()]));
    }

    public void write(Path var1, IMappingFile.Format var2, String ... var3) throws IOException;
}

