/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.installertools.Task;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.INamedMappingFile;
import net.minecraftforge.srgutils.IRenamer;

public class ChainMappings
extends Task {
    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec leftO = parser.accepts("left").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec leftNamesO = parser.accepts("left-names").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec rightO = parser.accepts("right").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec rightNamesO = parser.accepts("right-names").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder classesO = parser.accepts("classes");
        OptionSpecBuilder fieldsO = parser.accepts("fields");
        OptionSpecBuilder methodsO = parser.accepts("methods");
        OptionSpecBuilder paramsO = parser.accepts("params");
        try {
            OptionSet options = parser.parse(args);
            File left = (File)options.valueOf((OptionSpec)leftO);
            File right = (File)options.valueOf((OptionSpec)rightO);
            String[] leftNames = this.parseNames(options, (OptionSpec<String>)leftNamesO);
            String[] rightNames = this.parseNames(options, (OptionSpec<String>)rightNamesO);
            File output = (File)options.valueOf((OptionSpec)outputO);
            boolean selective = options.has((OptionSpec)classesO) || options.has((OptionSpec)methodsO) || options.has((OptionSpec)fieldsO) || options.has((OptionSpec)paramsO);
            boolean classes = !selective || options.has((OptionSpec)classesO);
            boolean fields = !selective || options.has((OptionSpec)fieldsO);
            boolean methods = !selective || options.has((OptionSpec)methodsO);
            boolean params = !selective || options.has((OptionSpec)paramsO);
            this.log("Left:    " + left);
            this.log("         " + (leftNames == null ? "null" : (String)options.valueOf((OptionSpec)leftNamesO)));
            this.log("Right:   " + right);
            this.log("         " + (rightNames == null ? "null" : (String)options.valueOf((OptionSpec)rightNamesO)));
            this.log("Classes: " + classes);
            this.log("Fields:  " + fields);
            this.log("Methods: " + methods);
            this.log("Params:  " + params);
            this.log("Output:  " + output);
            if (output.exists() && !this.delete(output)) {
                this.error("Could not delete output file: " + output);
            }
            if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
                this.error("Could not make output folders: " + output.getParentFile());
            }
            if (!left.exists()) {
                this.error("Left does not exist: " + left);
            }
            if (!right.exists()) {
                this.error("Right does not exist: " + right);
            }
            IMappingFile leftM = leftNames == null ? IMappingFile.load((File)left) : INamedMappingFile.load((File)left).getMap(leftNames[0], leftNames[1]);
            IMappingFile rightM = rightNames == null ? IMappingFile.load((File)right) : INamedMappingFile.load((File)right).getMap(rightNames[0], rightNames[1]);
            IMappingFile outputM = leftM.rename(this.makeRenamer(rightM, classes, fields, methods, params));
            outputM.write(output.toPath(), IMappingFile.Format.TSRG2, false);
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private boolean delete(File path) throws IOException {
        if (path.isDirectory()) {
            return Files.walk(path.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).map(File::delete).anyMatch(v -> v == false);
        }
        return path.delete();
    }

    private String[] parseNames(OptionSet options, OptionSpec<String> spec) {
        if (!options.has(spec)) {
            return null;
        }
        String[] ret = ((String)options.valueOf(spec)).split(",");
        if (ret.length != 2) {
            throw new IllegalArgumentException("Name argument must be exactly two values, EXA: left,right");
        }
        return ret;
    }

    protected IRenamer makeRenamer(final IMappingFile link, final boolean classes, final boolean fields, final boolean methods, final boolean params) {
        return new IRenamer(){

            public String rename(IMappingFile.IPackage value) {
                return link.remapPackage(value.getMapped());
            }

            public String rename(IMappingFile.IClass value) {
                return classes ? link.remapClass(value.getMapped()) : value.getMapped();
            }

            public String rename(IMappingFile.IField value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null || !fields ? value.getMapped() : cls.remapField(value.getMapped());
            }

            public String rename(IMappingFile.IMethod value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null || !methods ? value.getMapped() : cls.remapMethod(value.getMapped(), value.getMappedDescriptor());
            }

            public String rename(IMappingFile.IParameter value) {
                IMappingFile.IMethod mtd = (IMappingFile.IMethod)value.getParent();
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)mtd.getParent()).getMapped());
                mtd = cls == null ? null : cls.getMethod(mtd.getMapped(), mtd.getMappedDescriptor());
                return mtd == null || !params ? value.getMapped() : mtd.remapParameter(value.getIndex(), value.getMapped());
            }
        };
    }
}

