/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util.runs;

import java.io.File;
import java.util.List;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.runs.RunConfigGenerator;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="IDE runs should always be regenerated")
abstract class GenIDERunsTask
extends DefaultTask {
    public GenIDERunsTask() {
        this.setGroup("ForgeGradle runs");
        this.getRunConfigurationsFolderName().set(this.getRunConfigurationsFolder().map(dir -> dir.getAsFile().getAbsolutePath()));
    }

    @TaskAction
    public void run() {
        File runConfigurationsDir = ((Directory)this.getRunConfigurationsFolder().get()).getAsFile();
        if (!runConfigurationsDir.exists() && !runConfigurationsDir.mkdirs()) {
            throw new RuntimeException("Could not create run configurations directory: " + runConfigurationsDir.getAbsolutePath());
        }
        RunConfigGenerator runConfigGenerator = (RunConfigGenerator)this.getRunConfigGenerator().get();
        MinecraftExtension minecraft = (MinecraftExtension)((Object)this.getMinecraftExtension().get());
        Project project = this.getProject();
        List additionalClientArgs = (List)this.getAdditionalClientArgs().get();
        runConfigGenerator.createRunConfiguration(minecraft, runConfigurationsDir, project, additionalClientArgs, (FileCollection)this.getMinecraftArtifacts(), (FileCollection)this.getRuntimeClasspathArtifacts());
    }

    @Internal
    public abstract DirectoryProperty getRunConfigurationsFolder();

    @Input
    protected abstract Property<String> getRunConfigurationsFolderName();

    @Internal
    public abstract Property<RunConfigGenerator> getRunConfigGenerator();

    @Internal
    public abstract Property<MinecraftExtension> getMinecraftExtension();

    @Input
    public abstract ListProperty<String> getAdditionalClientArgs();

    @InputFiles
    public abstract ConfigurableFileCollection getMinecraftArtifacts();

    @InputFiles
    public abstract ConfigurableFileCollection getRuntimeClasspathArtifacts();
}

