/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks.ide;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.runs.IntellijRunGenerator;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.plugins.ide.idea.model.IdeaModel;

public abstract class CopyIntellijResources
extends Copy {
    public static final String NAME = "copyIntellijResources";

    public CopyIntellijResources() {
        this.getOutputs().upToDateWhen(task -> false);
    }

    public void configure(IdeaModel model, Project project) {
        this.setDestinationDir(new File((File)project.getLayout().getBuildDirectory().getAsFile().get(), this.getName()));
        Path destination = this.getDestinationDir().toPath();
        for (SourceSet sourceSet : ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets()) {
            this.dependsOn(new Object[]{sourceSet.getProcessResourcesTaskName()});
            ProcessResources processResources = (ProcessResources)project.getTasks().named(sourceSet.getProcessResourcesTaskName(), ProcessResources.class).get();
            String outName = Utils.getIntellijOutName(sourceSet);
            String outPath = IntellijRunGenerator.getIdeaPathsForSourceset(project, model, outName, null).findFirst().orElseGet(() -> new File(model.getModule().getOutputDir(), outName + "/resources").getAbsolutePath());
            CopySpecInternal spec = this.getMainSpec().addChild();
            spec.into((Object)destination.relativize(Paths.get(outPath, new String[0])).toString());
            spec.with(new CopySpec[]{processResources.getRootSpec()});
        }
    }
}

