/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.util;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.EnvironmentChecks;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.userdev.util.Deobfuscator;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;

public class DeobfuscatingRepo
extends BaseRepo {
    private final Project project;
    private final Configuration origin;
    private ResolvedConfiguration resolvedOrigin;
    private final Deobfuscator deobfuscator;

    public DeobfuscatingRepo(Project project, Configuration origin, Deobfuscator deobfuscator) {
        super(Utils.getCache(project, "mod_remap_repo"), project.getLogger());
        this.project = project;
        this.origin = origin;
        this.deobfuscator = deobfuscator;
    }

    @Nullable
    private String getMappings(String version) {
        if (!version.contains("_mapped_")) {
            return null;
        }
        return version.split("_mapped_")[1];
    }

    @Override
    protected void configureFilter(RepositoryContentDescriptor filter) {
        filter.includeVersionByRegex(".*", ".*", ".*_mapped_.*");
    }

    @Override
    public File findFile(ArtifactIdentifier artifact) throws IOException {
        String version = artifact.getVersion();
        String mappings = this.getMappings(version);
        if (mappings == null) {
            return null;
        }
        version = version.substring(0, version.length() - (mappings.length() + "_mapped_".length()));
        String classifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
        Artifact unmappedArtifact = Artifact.from(artifact).withVersion(version);
        String ext = unmappedArtifact.getExtension();
        this.debug("  " + this.REPO_NAME + " Request: " + this.clean(artifact) + " Mapping: " + mappings);
        if ("pom".equals(ext)) {
            return this.findPom(unmappedArtifact, mappings);
        }
        if ("jar".equals(ext)) {
            if ("sources".equals(classifier)) {
                return this.findSource(unmappedArtifact, mappings);
            }
            return this.findRaw(unmappedArtifact, mappings);
        }
        throw new RuntimeException("Invalid deobf dependency: " + artifact);
    }

    @Nullable
    private File findPom(Artifact artifact, String mapping) throws IOException {
        Optional<File> orig = this.findArtifactFile(artifact);
        if (!orig.isPresent()) {
            return null;
        }
        File origFile = orig.get();
        return this.deobfuscator.deobfPom(origFile, mapping, this.getArtifactPath(artifact, mapping));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedConfiguration getResolvedOrigin() {
        Configuration configuration = this.origin;
        synchronized (configuration) {
            if (this.resolvedOrigin == null) {
                this.resolvedOrigin = this.origin.getResolvedConfiguration();
            }
            return this.resolvedOrigin;
        }
    }

    private Optional<File> findArtifactFile(Artifact artifact) {
        Stream deps = this.getResolvedOrigin().getFirstLevelModuleDependencies(artifact.asDependencySpec()).stream();
        return deps.flatMap(d -> d.getModuleArtifacts().stream().filter(artifact.asArtifactMatcher())).map(ResolvedArtifact::getFile).filter(File::exists).findAny();
    }

    @Nullable
    private File findRaw(Artifact artifact, String mapping) throws IOException {
        Optional<File> orig = this.findArtifactFile(artifact);
        if (!orig.isPresent()) {
            return null;
        }
        File origFile = orig.get();
        return this.deobfuscator.deobfBinary(origFile, mapping, this.getArtifactPath(artifact, mapping));
    }

    @Nullable
    private File findSource(Artifact artifact, String mapping) throws IOException {
        if (!EnvironmentChecks.ENABLE_SOURCES.isEnabled()) {
            return null;
        }
        File noSourceFlag = this.cache(this.getArtifactPath(artifact, mapping) + ".nosources");
        if (noSourceFlag.exists()) {
            return null;
        }
        File origFile = MavenArtifactDownloader.manual(this.project, artifact.getDescriptor(), false);
        if (origFile == null) {
            try {
                noSourceFlag.getParentFile().mkdirs();
                noSourceFlag.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        return this.deobfuscator.deobfSources(origFile, mapping, this.getArtifactPath(artifact, mapping));
    }

    private String getArtifactPath(Artifact artifact, String mappings) {
        String newVersion = artifact.getVersion() + "_mapped_" + mappings;
        return artifact.withVersion(newVersion).getLocalPath();
    }
}

