/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.config.MCPConfigV2;
import net.minecraftforge.gradle.common.tasks.JarExec;
import net.minecraftforge.gradle.common.util.Utils;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class ApplyMCPFunction
extends JarExec {
    private final Map<String, Object> replacements = new HashMap<String, Object>();

    public ApplyMCPFunction() {
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(d -> d.file("output.jar")));
    }

    @Override
    @TaskAction
    public void apply() throws IOException {
        File mcp = ((RegularFile)this.getMCP().get()).getAsFile();
        MCPConfigV2 config = MCPConfigV2.getFromArchive(mcp);
        MCPConfigV1.Function function = config.getFunction((String)this.getFunctionName().get());
        this.getTool().set((Object)function.getVersion());
        this.getArgs().set(function.getArgs());
        try (ZipFile zip = new ZipFile(mcp);){
            function.getArgs().forEach(arg -> {
                String argName;
                if (arg.length() < 2 || !arg.startsWith("{") || !arg.endsWith("}")) {
                    return;
                }
                switch (argName = arg.substring(1, arg.length() - 1)) {
                    case "input": {
                        this.replacements.put((String)arg, ((RegularFile)this.getInput().get()).getAsFile().getAbsolutePath());
                        break;
                    }
                    case "output": {
                        this.replacements.put((String)arg, ((RegularFile)this.getOutput().get()).getAsFile().getAbsolutePath());
                        break;
                    }
                    case "log": {
                        this.replacements.put((String)arg, ((RegularFile)this.getOutput().get()).getAsFile().getAbsolutePath() + ".log");
                        break;
                    }
                    default: {
                        Object referencedData = config.getData().get(argName);
                        if (!(referencedData instanceof String)) break;
                        ZipEntry entry = zip.getEntry((String)referencedData);
                        if (entry == null) {
                            return;
                        }
                        String entryName = entry.getName();
                        try {
                            File data = this.makeFile(entry.getName());
                            if (entry.isDirectory()) {
                                Utils.extractDirectory(this::makeFile, zip, entryName);
                            } else {
                                Utils.extractFile(zip, entry, data);
                            }
                            this.replacements.put((String)arg, data.getAbsolutePath());
                            break;
                        }
                        catch (IOException e) {
                            this.getLogger().debug("Exception while extracting referenced data for token {} in task {}", new Object[]{arg, this.getName(), e});
                        }
                    }
                }
            });
        }
        super.apply();
    }

    @Override
    protected List<String> filterArgs(List<String> args) {
        return this.replaceArgs(args, this.replacements, null);
    }

    @InputFile
    public abstract RegularFileProperty getInput();

    @InputFile
    public abstract RegularFileProperty getMCP();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Input
    public abstract Property<String> getFunctionName();

    private File makeFile(String name) {
        return new File(((RegularFile)this.getOutput().get()).getAsFile().getParent(), name);
    }
}

