/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;
import org.apache.commons.io.IOUtils;
import org.gradle.api.logging.LogLevel;

class PatchFunction
implements MCPFunction {
    private String path;

    PatchFunction() {
    }

    @Override
    public void loadData(Map<String, String> data) {
        this.path = data.get("patches");
    }

    @Override
    public File execute(MCPEnvironment environment) throws Exception {
        boolean success;
        File input = (File)environment.getArguments().get("input");
        File output = environment.getFile("output.jar");
        File rejects = environment.getFile("rejects.zip");
        File hashFile = environment.getFile("lastinput.sha1");
        HashStore hashStore = new HashStore(environment.project).load(hashFile);
        hashStore.add(input);
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(environment.getConfigZip()));){
            ZipEntry e;
            while ((e = zin.getNextEntry()) != null) {
                if (!e.getName().startsWith(this.path)) continue;
                hashStore.add(e.getName().substring(this.path.length()), IOUtils.toByteArray((InputStream)zin));
            }
        }
        if (hashStore.isSame() && output.exists()) {
            return output;
        }
        CliOperation.Result result = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(environment.logger, LogLevel.LIFECYCLE)).basePath(input.toPath()).patchesPath(environment.getConfigZip().toPath()).patchesPrefix(this.path).outputPath(output.toPath()).verbose(false).mode(PatchMode.OFFSET).rejectsPath(rejects.toPath()).build().operate();
        boolean bl = success = result.exit == 0;
        if (!success) {
            environment.logger.error("Rejects saved to: {}", (Object)rejects);
            throw new RuntimeException("Patch failure.");
        }
        hashStore.save(hashFile);
        return output;
    }
}

