/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.gradle.mcp.function.DownloadFileFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;

class DownloadCoreFunction
extends DownloadFileFunction {
    DownloadCoreFunction(String artifact, String ext) {
        super((MCPEnvironment env) -> artifact + '.' + ext, (MCPEnvironment env) -> DownloadCoreFunction.getDownloadInfo(env, artifact, ext));
    }

    private static DownloadFileFunction.DownloadInfo getDownloadInfo(MCPEnvironment environment, String artifact, String extension) {
        try {
            Gson gson = new Gson();
            FileReader reader = new FileReader(environment.getStepOutput("downloadJson"));
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
            JsonObject artifactInfo = json.getAsJsonObject("downloads").getAsJsonObject(artifact);
            String url = artifactInfo.get("url").getAsString();
            String hash = artifactInfo.get("sha1").getAsString();
            String version = json.getAsJsonObject().get("id").getAsString();
            return new DownloadFileFunction.DownloadInfo(url, hash, extension, version, artifact);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

