/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util.runs;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.runs.RunConfigGenerator;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Running Minecraft cannot be cached")
abstract class MinecraftRunTask
extends JavaExec {
    public MinecraftRunTask() {
        this.setGroup("ForgeGradle runs");
        this.setImpliesSubProjects(true);
        this.getJavaLauncher().convention(this.getJavaToolchainService().launcherFor(((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain()));
    }

    @TaskAction
    public void exec() {
        Project project = this.getProject();
        RunConfig runConfig = (RunConfig)this.getRunConfig().get();
        File workDir = MinecraftRunTask.prepareWorkingDirectory(runConfig);
        Map<String, Supplier<String>> updatedTokens = RunConfigGenerator.configureTokensLazy(project, runConfig, RunConfigGenerator.mapModClassesToGradle(project, runConfig), (FileCollection)this.getMinecraftArtifacts(), (FileCollection)this.getRuntimeClasspathArtifacts());
        this.setWorkingDir(workDir);
        this.args(RunConfigGenerator.getArgsStream(runConfig, updatedTokens, false).toArray());
        runConfig.getJvmArgs().forEach(arg -> this.jvmArgs(new Object[]{runConfig.replace(updatedTokens, (String)arg)}));
        if (runConfig.isClient()) {
            ((List)this.getAdditionalClientArgs().get()).forEach(arg -> this.jvmArgs(new Object[]{runConfig.replace(updatedTokens, (String)arg)}));
        }
        runConfig.getEnvironment().forEach((key, value) -> this.environment((String)key, runConfig.replace(updatedTokens, (String)value)));
        runConfig.getProperties().forEach((key, value) -> this.systemProperty((String)key, runConfig.replace(updatedTokens, (String)value)));
        runConfig.getAllSources().stream().map(SourceSet::getRuntimeClasspath).forEach(xva$0 -> this.classpath(new Object[]{xva$0}));
        super.exec();
    }

    public static File prepareWorkingDirectory(RunConfig runConfig) {
        File workDir = new File(runConfig.getWorkingDirectory());
        if (!workDir.exists() && !workDir.mkdirs()) {
            throw new RuntimeException("Could not create working directory: " + workDir.getAbsolutePath());
        }
        return workDir;
    }

    @Input
    public abstract Property<RunConfig> getRunConfig();

    @Input
    public abstract ListProperty<String> getAdditionalClientArgs();

    @InputFiles
    public abstract ConfigurableFileCollection getMinecraftArtifacts();

    @InputFiles
    public abstract ConfigurableFileCollection getRuntimeClasspathArtifacts();
}

