/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import java.io.IOException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import net.minecraftforge.gradle.common.util.JavaVersionParser;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.util.GradleVersion;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class EnvironmentChecks {
    public static final String ENABLE_CERTIFICATE_CHECK_VARIABLE = "net.minecraftforge.gradle.check.certs";
    public static final String ENABLE_GRADLE_CHECK_VARIABLE = "net.minecraftforge.gradle.check.gradle";
    public static final String ENABLE_JAVA_CHECK_VARIABLE = "net.minecraftforge.gradle.check.java";
    private static final String FILTER_REPOS_VARIABLE = "net.minecraftforge.gradle.filter.repos";
    private static final String INVALIDATE_CACHE_VARIABLE = "net.minecraftforge.gradle.invalidate.cache";
    private static final String DEBUG_REPOS_VARIABLE = "net.minecraftforge.gradle.repo.debug";
    private static final String ENABLE_SOURCES_VARIABLE = "net.minecraftforge.gradle.repo.sources";
    private static final String ENABLE_RECOMPILE_VARIABLE = "net.minecraftforge.gradle.repo.recompile";
    private static final String RECOMPILE_ARGS_VARIABLE = "net.minecraftforge.gradle.repo.recompile.args";
    private static final String ENABLE_RECOMPILE_FORK_VARIABLE = "net.minecraftforge.gradle.repo.recompile.fork";
    private static final String RECOMPILE_FORK_ARGS_VARIABLE = "net.minecraftforge.gradle.repo.recompile.fork.args";
    private static final String AUTOMATIC_ATTACH_REPOS_VARIABLE = "net.minecraftforge.gradle.repo.attach";
    private static final EnvironmentFlag ENABLE_CERTIFICATE_CHECK = new EnvironmentFlag("net.minecraftforge.gradle.check.certs", true);
    private static final EnvironmentFlag ENABLE_GRADLE_CHECK = new EnvironmentFlag("net.minecraftforge.gradle.check.gradle", true);
    private static final EnvironmentFlag ENABLE_JAVA_CHECK = new EnvironmentFlag("net.minecraftforge.gradle.check.java", true);
    public static final EnvironmentFlag FILTER_REPOS = new EnvironmentFlag("net.minecraftforge.gradle.filter.repos", true);
    public static final EnvironmentFlag INVALIDATE_CACHE = new EnvironmentFlag("net.minecraftforge.gradle.invalidate.cache", false);
    public static final EnvironmentFlag DEBUG_REPOS = new EnvironmentFlag("net.minecraftforge.gradle.repo.debug", false);
    public static final EnvironmentFlag ENABLE_SOURCES = new EnvironmentFlag("net.minecraftforge.gradle.repo.sources", true);
    public static final EnvironmentFlag ENABLE_RECOMPILE = new EnvironmentFlag("net.minecraftforge.gradle.repo.recompile", true);
    public static final EnvironmentValue RECOMPILE_ARGS = new EnvironmentValue("net.minecraftforge.gradle.repo.recompile.args", null);
    public static final EnvironmentFlag ENABLE_RECOMPILE_FORK = new EnvironmentFlag("net.minecraftforge.gradle.repo.recompile.fork", false);
    public static final EnvironmentValue RECOMPILE_FORK_ARGS = new EnvironmentValue("net.minecraftforge.gradle.repo.recompile.fork.args", null);
    public static final EnvironmentFlag AUTOMATIC_ATTACH_REPOS = new EnvironmentFlag("net.minecraftforge.gradle.repo.attach", true);
    private static final Marker ENV_CHECK = MarkerFactory.getMarker((String)"forgegradle.env_check");

    public static void checkJavaRange(@Nullable JavaVersionParser.JavaVersion minVersionInclusive, @Nullable JavaVersionParser.JavaVersion maxVersionExclusive) {
        EnvironmentChecks.checkRange("java", JavaVersionParser.getCurrentJavaVersion(), minVersionInclusive, maxVersionExclusive, "", "");
    }

    public static void checkGradleRange(@Nullable GradleVersion minVersionInclusive, @Nullable GradleVersion maxVersionExclusive) {
        EnvironmentChecks.checkRange("Gradle", GradleVersion.current(), minVersionInclusive, maxVersionExclusive, "\nNote: Upgrade your gradle version first before trying to switch to FG6.", "");
    }

    private static <T> void checkRange(String name, Comparable<T> current, @Nullable T minVersionInclusive, @Nullable T maxVersionExclusive, String additionalMin, String additionalMax) {
        if (minVersionInclusive != null && current.compareTo(minVersionInclusive) < 0) {
            throw new EnvironmentCheckFailedException(String.format("Found %s version %s. Minimum required is %s.%s", name, current, minVersionInclusive, additionalMin));
        }
        if (maxVersionExclusive != null && current.compareTo(maxVersionExclusive) >= 0) {
            throw new EnvironmentCheckFailedException(String.format("Found %s version %s. Versions %s and newer are not supported yet.%s", name, current, maxVersionExclusive, additionalMax));
        }
    }

    public static void checkEnvironment(Project project) {
        Logger logger = project.getLogger();
        if (ENABLE_JAVA_CHECK.isEnabled()) {
            logger.debug(ENV_CHECK, "Checking Java version");
            EnvironmentChecks.checkJavaRange(JavaVersionParser.parseJavaVersion("1.8.0_101"), null);
        } else {
            logger.debug(ENV_CHECK, "Java version check disabled by system property");
        }
        if (ENABLE_GRADLE_CHECK.isEnabled()) {
            logger.debug(ENV_CHECK, "Checking Gradle version");
            EnvironmentChecks.checkGradleRange(GradleVersion.version((String)"8.1"), GradleVersion.version((String)"9.0"));
        } else {
            logger.debug(ENV_CHECK, "Gradle version check disabled by system property");
        }
        if (ENABLE_CERTIFICATE_CHECK.isEnabled()) {
            logger.debug(ENV_CHECK, "Checking server connections");
            EnvironmentChecks.testServerConnection("https://maven.minecraftforge.net/");
            EnvironmentChecks.testServerConnection("https://libraries.minecraft.net/");
        } else {
            logger.debug(ENV_CHECK, "Server connection check disabled by system property");
        }
    }

    private static void testServerConnection(String url) {
        try {
            HttpsURLConnection conn = (HttpsURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("HEAD");
            conn.connect();
            conn.getResponseCode();
        }
        catch (SSLException e) {
            throw new EnvironmentCheckFailedException(String.format("Failed to validate certificate for host '%s'. To disable this check, re-run with '-D%s=false'.", url, ENABLE_CERTIFICATE_CHECK_VARIABLE), e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class EnvironmentCheckFailedException
    extends RuntimeException {
        EnvironmentCheckFailedException(String message) {
            super(message);
        }

        EnvironmentCheckFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class EnvironmentValue {
        private final String key;
        private final String simpleKey;
        private final String _default;

        private EnvironmentValue(String key, String _default) {
            this.key = key;
            this.simpleKey = key.replace("net.minecraftforge.gradle.", "fg.");
            this._default = _default;
        }

        public String getValue() {
            String val = System.getProperty(this.key);
            if (val == null) {
                val = System.getProperty(this.simpleKey);
            }
            return val == null ? this._default : val;
        }
    }

    public static final class EnvironmentFlag {
        private final String key;
        private final String simpleKey;
        private final boolean _default;

        private EnvironmentFlag(String key, boolean _default) {
            this.key = key;
            this.simpleKey = key.replace("net.minecraftforge.gradle.", "fg.");
            this._default = _default;
        }

        public boolean isEnabled() {
            String val = System.getProperty(this.key);
            if (val == null) {
                val = System.getProperty(this.simpleKey);
            }
            return val == null ? this._default : Boolean.parseBoolean(val);
        }
    }
}

