package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import com.google.common.collect.ImmutableList;

import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraftforge.common.BiomeDictionary.Type;
import net.minecraftforge.common.util.EnumHelper;

public class BiomeManager
{
    private static TrackedList<BiomeEntry>[] biomes = setupBiomes();
    
    /*
     * These lists should no longer be accessed directly. Instead, use the appropriate add, remove and get methods within this class.
     */
    @Deprecated
    public static List<BiomeEntry> desertBiomes = biomes[BiomeType.DESERT.ordinal()];
    @Deprecated
    public static List<BiomeEntry> warmBiomes = biomes[BiomeType.WARM.ordinal()];
    @Deprecated
    public static List<BiomeEntry> coolBiomes = biomes[BiomeType.COOL.ordinal()];
    @Deprecated
    public static List<BiomeEntry> icyBiomes = biomes[BiomeType.ICY.ordinal()];
    
    private static boolean isModded = false;
    
    public static List<BiomeGenBase> oceanBiomes = new ArrayList<BiomeGenBase>();
    
    public static ArrayList<BiomeGenBase> strongHoldBiomes = new ArrayList<BiomeGenBase>();
    public static ArrayList<BiomeGenBase> strongHoldBiomesBlackList = new ArrayList<BiomeGenBase>();

    static
    {
        oceanBiomes.add(BiomeGenBase.field_76771_b);
        oceanBiomes.add(BiomeGenBase.field_150575_M);
        oceanBiomes.add(BiomeGenBase.field_76776_l);
    }
    
    private static TrackedList<BiomeEntry>[] setupBiomes()
    {
        TrackedList<BiomeEntry>[] currentBiomes = new TrackedList[BiomeType.values().length];
        List list = new ArrayList();
        
        list.add(new BiomeEntry(BiomeGenBase.field_76767_f, 10));
        list.add(new BiomeEntry(BiomeGenBase.field_150585_R, 10));
        list.add(new BiomeEntry(BiomeGenBase.field_76770_e, 10));
        list.add(new BiomeEntry(BiomeGenBase.field_76772_c, 10));
        list.add(new BiomeEntry(BiomeGenBase.field_150583_P, 10));
        list.add(new BiomeEntry(BiomeGenBase.field_76780_h, 10));
        
        currentBiomes[BiomeType.WARM.ordinal()] = new TrackedList(list);
        list.clear();

        list.add(new BiomeEntry(BiomeGenBase.field_76767_f, 10));
        list.add(new BiomeEntry(BiomeGenBase.field_76770_e, 10));
        list.add(new BiomeEntry(BiomeGenBase.field_76768_g, 10));
        list.add(new BiomeEntry(BiomeGenBase.field_76772_c, 10));
        
        currentBiomes[BiomeType.COOL.ordinal()] = new TrackedList(list);
        list.clear();

        list.add(new BiomeEntry(BiomeGenBase.field_76774_n, 30));
        list.add(new BiomeEntry(BiomeGenBase.field_150584_S, 10));

        currentBiomes[BiomeType.ICY.ordinal()] = new TrackedList(list);
        list.clear();
        
        currentBiomes[BiomeType.DESERT.ordinal()] = new TrackedList(list);
        
        return currentBiomes;
    }

    @SuppressWarnings("unchecked")
    public static void addVillageBiome(BiomeGenBase biome, boolean canSpawn)
    {
        if (!MapGenVillage.field_75055_e.contains(biome))
        {
            ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>(MapGenVillage.field_75055_e);
            biomes.add(biome);
            MapGenVillage.field_75055_e = biomes;
        }
    }

    @SuppressWarnings("unchecked")
    public static void removeVillageBiome(BiomeGenBase biome)
    {
        if (MapGenVillage.field_75055_e.contains(biome))
        {
            ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>(MapGenVillage.field_75055_e);
            biomes.remove(biome);
            MapGenVillage.field_75055_e = biomes;
        }
    }

    public static void addStrongholdBiome(BiomeGenBase biome)
    {
        if (!strongHoldBiomes.contains(biome))
        {
            strongHoldBiomes.add(biome);
        }
    }

    public static void removeStrongholdBiome(BiomeGenBase biome)
    {
        if (!strongHoldBiomesBlackList.contains(biome))
        {
            strongHoldBiomesBlackList.add(biome);
        }
    }

    public static void addSpawnBiome(BiomeGenBase biome)
    {
        if (!WorldChunkManager.allowedBiomes.contains(biome))
        {
            WorldChunkManager.allowedBiomes.add(biome);
        }
    }

    public static void removeSpawnBiome(BiomeGenBase biome)
    {
        if (WorldChunkManager.allowedBiomes.contains(biome))
        {
            WorldChunkManager.allowedBiomes.remove(biome);
        }
    }
    
    public static void addBiome(BiomeType type, BiomeEntry entry)
    {
        isModded = true;
        
        int idx = type.ordinal();
        List<BiomeEntry> list = idx > biomes.length ? null : biomes[idx];
        if (list != null) list.add(entry);
    }
    
    public static void removeBiome(BiomeType type, BiomeEntry entry)
    {
        isModded = true;
        
        int idx = type.ordinal();
        List<BiomeEntry> list = idx > biomes.length ? null : biomes[idx];
        
        if (list != null && list.contains(entry))
        {
            list.remove(entry);
        }
    }
    
    public static ImmutableList<BiomeEntry> getBiomes(BiomeType type)
    {
        int idx = type.ordinal();
        List<BiomeEntry> list = idx > biomes.length ? null : biomes[idx];
        
        return list != null ? ImmutableList.copyOf(list) : null;
    }
    
    public static boolean isTypeListModded(BiomeType type)
    {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx > biomes.length ? null : biomes[idx];
        
        if (list != null) return list.isModded();
        
        return false;
    }
    
    public static enum BiomeType
    {
        DESERT, WARM, COOL, ICY;
        
        public static BiomeType getType(String name)
        {
            name = name.toUpperCase();
            
            for (BiomeType t : values())
            {
                if (t.name().equals(name)) return t;
            }
            
            BiomeType ret = EnumHelper.addEnum(BiomeType.class, name, BiomeType.class);
            
            if (ret.ordinal() >= biomes.length)
            {
                biomes = Arrays.copyOf(biomes, ret.ordinal());
            }
            
            return ret;
        }
    }

    public static class BiomeEntry extends WeightedRandom.Item
    {
        public final BiomeGenBase biome;
        
        public BiomeEntry(BiomeGenBase biome, int weight)
        {
            super(weight);
            
            this.biome = biome;
        }
    }
    
    private static class TrackedList<E> extends ArrayList<E>
    {
        private boolean isModded = false;
        
        public TrackedList(Collection<? extends E> c) 
        {
            super(c);
        }
        
        @Override
        public E set(int index, E element) 
        {
            isModded = true;
            return super.set(index, element);
        }
        
        @Override
        public boolean add(E e) 
        {
            isModded = true;
            return super.add(e);
        }
        
        @Override
        public void add(int index, E element) 
        {
            isModded = true;
            super.add(index, element);
        }
            
        @Override
        public E remove(int index) 
        {
            isModded = true;
            return super.remove(index);
        }

        @Override
        public boolean remove(Object o) 
        {
            isModded = true;
            return super.remove(o);
        }

        @Override
        public void clear() 
        {
            isModded = true;
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) 
        {
            isModded = true;
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) 
        {
            isModded = true;
            return super.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) 
        {
            isModded = true;
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) 
        {
            isModded = true;
            return super.retainAll(c);
        }

        public boolean isModded()
        {
            return isModded;
        }
    }
}
