/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.util;

import codechicken.diffpatch.util.PathType;
import codechicken.diffpatch.util.Utils;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public abstract class InputPath {
    private final PathType type;

    protected InputPath(PathType type) {
        this.type = type;
    }

    public PathType getType() {
        return this.type;
    }

    public abstract boolean isFile();

    public abstract boolean exists();

    public abstract Path toPath();

    public abstract InputStream open() throws IOException;

    public abstract List<String> readAllLines() throws IOException;

    public abstract String getName();

    public abstract ArchiveFormat getFormat();

    public static class NullPath
    extends InputPath {
        public static final NullPath INSTANCE = new NullPath();

        public NullPath() {
            super(PathType.NULL);
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public Path toPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> readAllLines() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchiveFormat getFormat() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PipePath
    extends InputPath {
        private final InputStream pipe;
        private final ArchiveFormat format;

        public PipePath(InputStream pipe, ArchiveFormat format) {
            super(PathType.PIPE);
            this.pipe = pipe;
            this.format = format;
        }

        @Override
        public InputStream open() {
            return Utils.protectClose(this.pipe);
        }

        @Override
        public List<String> readAllLines() throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.open()));){
                List<String> list = reader.lines().collect(Collectors.toList());
                return list;
            }
        }

        @Override
        public ArchiveFormat getFormat() {
            return this.format;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Path toPath() {
            throw new UnsupportedOperationException();
        }
    }

    public static class FilePath
    extends InputPath {
        private final Path path;
        private final ArchiveFormat format;
        private final OpenOption[] opts;

        public FilePath(Path path, ArchiveFormat format, OpenOption ... opts) {
            super(PathType.PATH);
            this.path = path;
            this.format = format;
            this.opts = opts;
        }

        @Override
        public boolean isFile() {
            return Files.isRegularFile(this.path, new LinkOption[0]);
        }

        @Override
        public boolean exists() {
            return Files.exists(this.path, new LinkOption[0]);
        }

        @Override
        public Path toPath() {
            return this.path;
        }

        @Override
        public InputStream open() throws IOException {
            return Files.newInputStream(this.path, this.opts);
        }

        @Override
        public List<String> readAllLines() throws IOException {
            return Files.readAllLines(this.path);
        }

        @Override
        public String getName() {
            return this.path.getFileName().toString();
        }

        @Override
        public ArchiveFormat getFormat() {
            return this.format;
        }
    }
}

