/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.util;

import codechicken.repack.it.unimi.dsi.fastutil.objects.Object2CharMap;
import codechicken.repack.it.unimi.dsi.fastutil.objects.Object2CharOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CharRepresenter {
    private final List<String> charToLine = new ArrayList<String>();
    private final Object2CharMap<String> lineToChar = new Object2CharOpenHashMap<String>();
    private final List<String> charToWord = new ArrayList<String>();
    private final Object2CharMap<String> wordToChar = new Object2CharOpenHashMap<String>();
    private char[] buf = new char[4096];

    public CharRepresenter() {
        this.charToLine.add("\u0000");
        for (char i = '\u0000'; i < '\u0080'; i = (char)(i + '\u0001')) {
            this.charToWord.add(Character.valueOf(i).toString());
        }
    }

    public String getWordForChar(char ch) {
        return this.charToWord.get(ch);
    }

    public char addLine(String line) {
        return this.lineToChar.computeCharIfAbsent(line, e -> {
            this.charToLine.add(line);
            return (char)(this.charToLine.size() - 1);
        });
    }

    public char addWord(String word) {
        if (word.length() == 1 && word.charAt(0) <= '\u0080') {
            return word.charAt(0);
        }
        return this.wordToChar.computeCharIfAbsent(word, e -> {
            this.charToWord.add(word);
            return (char)(this.charToWord.size() - 1);
        });
    }

    public String wordsToChars(String line) {
        int len;
        int b = 0;
        for (int i = 0; i < line.length(); i += len) {
            char c = line.charAt(i);
            len = 1;
            if (Character.isLetter(c)) {
                while (i + len < line.length() && Character.isLetterOrDigit(line.charAt(i + len))) {
                    ++len;
                }
            } else if (Character.isDigit(c)) {
                while (i + len < line.length() && Character.isDigit(line.charAt(i + len))) {
                    ++len;
                }
            } else if (c == ' ' || c == '\t') {
                while (i + len < line.length() && line.charAt(i + len) == c) {
                    ++len;
                }
            }
            String word = line.substring(i, i + len);
            if (b > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
            }
            this.buf[b++] = this.addWord(word);
        }
        return new String(this.buf, 0, b);
    }

    public String linesToChars(List<String> lines) {
        char[] buf = new char[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            buf[i] = this.addLine(lines.get(i));
        }
        return new String(buf);
    }

    public int getMaxLineChar() {
        return this.charToLine.size();
    }

    public int getMaxWordChar() {
        return this.charToWord.size();
    }
}

