/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.zip.GZIPInputStream;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.objectweb.asm.commons.Remapper;

public final class TinyUtils {
    private static final String toEscape = "\\\n\r\u0000\t";
    private static final String escaped = "\\nr0t";

    private TinyUtils() {
    }

    public static IMappingProvider createTinyMappingProvider(Path mappings, String fromM, String toM) {
        return out -> {
            try (BufferedReader reader = TinyUtils.getMappingReader(mappings.toFile());){
                TinyUtils.readInternal(reader, fromM, toM, out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static BufferedReader getMappingReader(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        if (file.getName().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static IMappingProvider createTinyMappingProvider(BufferedReader reader, String fromM, String toM) {
        return out -> {
            try {
                TinyUtils.readInternal(reader, fromM, toM, out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static void readInternal(BufferedReader reader, String fromM, String toM, final IMappingProvider.MappingAcceptor out) throws IOException {
        final ArrayList methodMappings = new ArrayList();
        final ArrayList methodArgMappings = new ArrayList();
        final ArrayList methodVarMappings = new ArrayList();
        final ArrayList fieldMappings = new ArrayList();
        final Set members = Collections.newSetFromMap(new IdentityHashMap());
        IMappingProvider.MappingAcceptor tmp = new IMappingProvider.MappingAcceptor(){

            @Override
            public void acceptClass(String srcName, String dstName) {
                out.acceptClass(srcName, dstName);
            }

            @Override
            public void acceptMethod(IMappingProvider.Member method, String dstName) {
                methodMappings.add(new MemberMapping(method, dstName));
                members.add(method);
            }

            @Override
            public void acceptMethodArg(IMappingProvider.Member method, int lvIndex, String dstName) {
                methodArgMappings.add(new MethodArgMapping(method, lvIndex, dstName));
                members.add(method);
            }

            @Override
            public void acceptMethodVar(IMappingProvider.Member method, int lvIndex, int startOpIdx, int asmIndex, String dstName) {
                methodVarMappings.add(new MethodVarMapping(method, lvIndex, startOpIdx, asmIndex, dstName));
                members.add(method);
            }

            @Override
            public void acceptField(IMappingProvider.Member field, String dstName) {
                fieldMappings.add(new MemberMapping(field, dstName));
                members.add(field);
            }
        };
        TinyUtils.read(reader, fromM, toM, tmp, (remapClasses, classMapper) -> {
            for (IMappingProvider.Member m : members) {
                if (remapClasses.booleanValue()) {
                    m.owner = classMapper.map(m.owner);
                }
                m.desc = classMapper.mapDesc(m.desc);
            }
        });
        for (Object m : methodMappings) {
            out.acceptMethod(((MemberMapping)m).member, ((MemberMapping)m).newName);
        }
        for (Object m : methodArgMappings) {
            out.acceptMethodArg(((MethodArgMapping)m).method, ((MethodArgMapping)m).lvIndex, ((MethodArgMapping)m).newName);
        }
        for (Object m : methodVarMappings) {
            out.acceptMethodVar(((MethodVarMapping)m).method, ((MethodVarMapping)m).lvIndex, ((MethodVarMapping)m).startOpIdx, ((MethodVarMapping)m).asmIndex, ((MethodVarMapping)m).newName);
        }
        for (Object m : fieldMappings) {
            out.acceptField(((MemberMapping)m).member, ((MemberMapping)m).newName);
        }
    }

    public static void read(BufferedReader reader, String from, String to, IMappingProvider.MappingAcceptor out, BiConsumer<Boolean, SimpleClassMapper> postProcessor) throws IOException {
        String headerLine = reader.readLine();
        if (headerLine == null) {
            throw new EOFException();
        }
        if (headerLine.startsWith("v1\t")) {
            TinyUtils.readV1(reader, from, to, headerLine, out, postProcessor);
        } else if (headerLine.startsWith("tiny\t2\t")) {
            TinyUtils.readV2(reader, from, to, headerLine, out, postProcessor);
        } else {
            throw new IOException("Invalid mapping version!");
        }
    }

    private static void readV1(BufferedReader reader, String from, String to, String headerLine, IMappingProvider.MappingAcceptor out, BiConsumer<Boolean, SimpleClassMapper> postProcessor) throws IOException {
        String line;
        HashMap<String, String> obfFrom;
        List<String> headerList = Arrays.asList(headerLine.split("\t"));
        int fromIndex = headerList.indexOf(from) - 1;
        int toIndex = headerList.indexOf(to) - 1;
        if (fromIndex < 0) {
            throw new IOException("Could not find mapping '" + from + "'!");
        }
        if (toIndex < 0) {
            throw new IOException("Could not find mapping '" + to + "'!");
        }
        HashMap<String, String> hashMap = obfFrom = fromIndex != 0 ? new HashMap<String, String>() : null;
        while ((line = reader.readLine()) != null) {
            boolean isMethod;
            String[] splitLine = line.split("\t", -1);
            if (splitLine.length < 2) continue;
            String type = splitLine[0];
            if ("CLASS".equals(type)) {
                out.acceptClass(splitLine[1 + fromIndex], splitLine[1 + toIndex]);
                if (obfFrom == null || splitLine[1 + fromIndex].isEmpty()) continue;
                obfFrom.put(splitLine[1], splitLine[1 + fromIndex]);
                continue;
            }
            if ("FIELD".equals(type)) {
                isMethod = false;
            } else {
                if (!"METHOD".equals(type)) continue;
                isMethod = true;
            }
            String owner = splitLine[1];
            String name = splitLine[3 + fromIndex];
            String desc = splitLine[2];
            String nameTo = splitLine[3 + toIndex];
            IMappingProvider.Member member = new IMappingProvider.Member(owner, name, desc);
            if (nameTo.isEmpty()) continue;
            if (isMethod) {
                out.acceptMethod(member, nameTo);
                continue;
            }
            out.acceptField(member, nameTo);
        }
        if (obfFrom != null) {
            postProcessor.accept(true, new SimpleClassMapper(obfFrom));
        }
    }

    private static void readV2(BufferedReader reader, String from, String to, String headerLine, IMappingProvider.MappingAcceptor out, BiConsumer<Boolean, SimpleClassMapper> postProcessor) throws IOException {
        String line;
        String[] parts;
        if (!headerLine.startsWith("tiny\t2\t") || (parts = TinyUtils.splitAtTab(headerLine, 0, 5)).length < 5) {
            throw new IOException("invalid/unsupported tiny file (incorrect header)");
        }
        List<String> namespaces = Arrays.asList(parts).subList(3, parts.length);
        int nsA = namespaces.indexOf(from);
        int nsB = namespaces.indexOf(to);
        HashMap<String, String> obfFrom = nsA != 0 ? new HashMap<String, String>() : null;
        int partCountHint = 2 + namespaces.size();
        int lineNumber = 1;
        boolean inHeader = true;
        boolean inClass = false;
        boolean inMethod = false;
        boolean escapedNames = false;
        String className = null;
        IMappingProvider.Member member = null;
        int varLvIndex = 0;
        int varStartOpIdx = 0;
        int varLvtIndex = 0;
        while ((line = reader.readLine()) != null) {
            String mappedName;
            int indent;
            ++lineNumber;
            if (line.isEmpty()) continue;
            for (indent = 0; indent < line.length() && line.charAt(indent) == '\t'; ++indent) {
            }
            parts = TinyUtils.splitAtTab(line, indent, partCountHint);
            String section = parts[0];
            if (indent == 0) {
                inMethod = false;
                inClass = false;
                inHeader = false;
                if (!section.equals("c")) continue;
                if (parts.length != namespaces.size() + 1) {
                    throw new IOException("invalid class decl in line " + lineNumber);
                }
                className = TinyUtils.unescapeOpt(parts[1 + nsA], escapedNames);
                mappedName = TinyUtils.unescapeOpt(parts[1 + nsB], escapedNames);
                if (!mappedName.isEmpty()) {
                    out.acceptClass(className, mappedName);
                }
                if (obfFrom != null && !className.isEmpty()) {
                    obfFrom.put(TinyUtils.unescapeOpt(parts[1], escapedNames), className);
                }
                inClass = true;
                continue;
            }
            if (indent == 1) {
                inMethod = false;
                if (inHeader) {
                    if (!section.equals("escaped-names")) continue;
                    escapedNames = true;
                    continue;
                }
                if (!inClass || !section.equals("m") && !section.equals("f")) continue;
                boolean isMethod = section.equals("m");
                if (parts.length != namespaces.size() + 2) {
                    throw new IOException("invalid " + (isMethod ? "method" : "field") + " decl in line " + lineNumber);
                }
                String memberDesc = TinyUtils.unescapeOpt(parts[1], escapedNames);
                String memberName = TinyUtils.unescapeOpt(parts[2 + nsA], escapedNames);
                String mappedName2 = TinyUtils.unescapeOpt(parts[2 + nsB], escapedNames);
                member = new IMappingProvider.Member(className, memberName, memberDesc);
                inMethod = isMethod;
                if (mappedName2.isEmpty()) continue;
                if (isMethod) {
                    out.acceptMethod(member, mappedName2);
                    continue;
                }
                out.acceptField(member, mappedName2);
                continue;
            }
            if (indent != 2) continue;
            if (inMethod && section.equals("p")) {
                if (parts.length != namespaces.size() + 2) {
                    throw new IOException("invalid method parameter decl in line " + lineNumber);
                }
                varLvIndex = Integer.parseInt(parts[1]);
                mappedName = TinyUtils.unescapeOpt(parts[2 + nsB], escapedNames);
                if (mappedName.isEmpty()) continue;
                out.acceptMethodArg(member, varLvIndex, mappedName);
                continue;
            }
            if (!inMethod || !section.equals("v")) continue;
            if (parts.length != namespaces.size() + 4) {
                throw new IOException("invalid method variable decl in line " + lineNumber);
            }
            varLvIndex = Integer.parseInt(parts[1]);
            varStartOpIdx = Integer.parseInt(parts[2]);
            varLvtIndex = Integer.parseInt(parts[3]);
            mappedName = TinyUtils.unescapeOpt(parts[4 + nsB], escapedNames);
            if (mappedName.isEmpty()) continue;
            out.acceptMethodVar(member, varLvIndex, varStartOpIdx, varLvtIndex, mappedName);
        }
        if (obfFrom != null) {
            postProcessor.accept(false, new SimpleClassMapper(obfFrom));
        }
    }

    private static String[] splitAtTab(String s, int offset, int partCountHint) {
        int pos;
        String[] ret = new String[Math.max(1, partCountHint)];
        int partCount = 0;
        while ((pos = s.indexOf(9, offset)) >= 0) {
            if (partCount == ret.length) {
                ret = Arrays.copyOf(ret, ret.length * 2);
            }
            ret[partCount++] = s.substring(offset, pos);
            offset = pos + 1;
        }
        if (partCount == ret.length) {
            ret = Arrays.copyOf(ret, ret.length + 1);
        }
        ret[partCount++] = s.substring(offset);
        return partCount == ret.length ? ret : Arrays.copyOf(ret, partCount);
    }

    private static String unescapeOpt(String str, boolean escapedNames) {
        return escapedNames ? TinyUtils.unescape(str) : str;
    }

    private static String unescape(String str) {
        int pos = str.indexOf(92);
        if (pos < 0) {
            return str;
        }
        StringBuilder ret = new StringBuilder(str.length() - 1);
        int start = 0;
        do {
            ret.append(str, start, pos);
            if (++pos >= str.length()) {
                throw new RuntimeException("incomplete escape sequence at the end");
            }
            int type = escaped.indexOf(str.charAt(pos));
            if (type < 0) {
                throw new RuntimeException("invalid escape character: \\" + str.charAt(pos));
            }
            ret.append(toEscape.charAt(type));
        } while ((pos = str.indexOf(92, start = pos + 1)) >= 0);
        ret.append(str, start, str.length());
        return ret.toString();
    }

    private static final class MemberMapping {
        public IMappingProvider.Member member;
        public String newName;

        MemberMapping(IMappingProvider.Member member, String newName) {
            this.member = member;
            this.newName = newName;
        }
    }

    private static final class MethodArgMapping {
        public IMappingProvider.Member method;
        public int lvIndex;
        public String newName;

        MethodArgMapping(IMappingProvider.Member method, int lvIndex, String newName) {
            this.method = method;
            this.lvIndex = lvIndex;
            this.newName = newName;
        }
    }

    private static final class MethodVarMapping {
        public IMappingProvider.Member method;
        public int lvIndex;
        public int startOpIdx;
        public int asmIndex;
        public String newName;

        MethodVarMapping(IMappingProvider.Member method, int lvIndex, int startOpIdx, int asmIndex, String newName) {
            this.method = method;
            this.lvIndex = lvIndex;
            this.startOpIdx = startOpIdx;
            this.asmIndex = asmIndex;
            this.newName = newName;
        }
    }

    private static class SimpleClassMapper
    extends Remapper {
        final Map<String, String> classMap;

        SimpleClassMapper(Map<String, String> map) {
            this.classMap = map;
        }

        public String map(String typeName) {
            return this.classMap.getOrDefault(typeName, typeName);
        }
    }
}

