/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper.extension.mixin.hard.annotation;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.tinyremapper.extension.mixin.common.data.CommonData;
import net.fabricmc.tinyremapper.extension.mixin.common.data.MxMember;
import net.fabricmc.tinyremapper.extension.mixin.hard.util.ConvertibleMappable;
import net.fabricmc.tinyremapper.extension.mixin.hard.util.IConvertibleString;
import net.fabricmc.tinyremapper.extension.mixin.hard.util.IdentityString;
import org.objectweb.asm.AnnotationVisitor;

public class OverwriteAnnotationVisitor
extends AnnotationVisitor {
    private final Collection<Consumer<CommonData>> tasks;
    private final MxMember method;
    private final List<String> targets;
    private boolean remap;

    public OverwriteAnnotationVisitor(Collection<Consumer<CommonData>> tasks, AnnotationVisitor delegate, MxMember method, boolean remap, List<String> targets) {
        super(589824, delegate);
        this.tasks = Objects.requireNonNull(tasks);
        this.method = Objects.requireNonNull(method);
        this.targets = Objects.requireNonNull(targets);
        this.remap = remap;
    }

    public void visit(String name, Object value) {
        if (name.equals("remap")) {
            this.remap = Objects.requireNonNull((Boolean)value);
        }
        super.visit(name, value);
    }

    public void visitEnd() {
        if (this.remap) {
            this.tasks.add(data -> new OverwriteMappable((CommonData)data, this.method, (Collection<String>)this.targets).result());
        }
        super.visitEnd();
    }

    private static class OverwriteMappable
    extends ConvertibleMappable {
        OverwriteMappable(CommonData data, MxMember self, Collection<String> targets) {
            super(data, self, targets);
        }

        @Override
        protected IConvertibleString getName() {
            return new IdentityString(this.self.getName());
        }

        @Override
        protected String getDesc() {
            return this.self.getDesc();
        }
    }
}

