/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.ipc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class IPCServer
implements AutoCloseable {
    private final ExecutorService loggerReceiverService = Executors.newSingleThreadExecutor();
    private final Path path;
    private final Consumer<String> consumer;
    private final CountDownLatch startupLock = new CountDownLatch(1);
    private boolean receivedMessage = false;

    public IPCServer(Path path, Consumer<String> consumer) {
        this.path = path;
        this.consumer = consumer;
        this.loggerReceiverService.submit(this::run);
        try {
            this.startupLock.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Timed out waiting for IPC server thread to start", e);
        }
    }

    public void run() {
        UnixDomainSocketAddress address = UnixDomainSocketAddress.of(this.path);
        try (ServerSocketChannel serverChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);){
            serverChannel.bind(address);
            this.startupLock.countDown();
            try (SocketChannel clientChannel = serverChannel.accept();
                 Scanner scanner = new Scanner((ReadableByteChannel)clientChannel, StandardCharsets.UTF_8);){
                while (!Thread.currentThread().isInterrupted()) {
                    if (!scanner.hasNextLine()) continue;
                    this.receivedMessage = true;
                    this.consumer.accept(scanner.nextLine());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to listen for IPC messages", e);
        }
    }

    @Override
    public void close() throws InterruptedException {
        this.loggerReceiverService.shutdownNow();
        this.loggerReceiverService.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public boolean hasReceivedMessage() {
        return this.receivedMessage;
    }

    public Path getPath() {
        return this.path;
    }
}

