/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import com.google.common.base.Suppliers;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.task.RemapSourcesJarTask;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.service.SharedService;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.lorenztiny.TinyMappingsReader;
import net.fabricmc.mappingio.tree.MappingTree;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.remapper.MercuryRemapper;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SourceRemapperService
implements SharedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceRemapperService.class);
    private final MappingsService mappingsService;
    private final ConfigurableFileCollection classpath;
    private final int javaCompileRelease;
    private final Supplier<Mercury> mercury = Suppliers.memoize(this::createMercury);

    public static synchronized SourceRemapperService create(SharedServiceManager serviceManager, RemapSourcesJarTask task) {
        Project project = task.getProject();
        String to = (String)task.getTargetNamespace().get();
        String from = (String)task.getSourceNamespace().get();
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        String id = extension.getMappingConfiguration().getBuildServiceName("sourceremapper", from, to);
        int javaCompileRelease = SourceRemapper.getJavaCompileRelease(project);
        return serviceManager.getOrCreateService(id, () -> new SourceRemapperService(MappingsService.createDefault(project, serviceManager, from, to), task.getClasspath(), javaCompileRelease));
    }

    private SourceRemapperService(MappingsService mappingsService, ConfigurableFileCollection classpath, int javaCompileRelease) {
        this.mappingsService = mappingsService;
        this.classpath = classpath;
        this.javaCompileRelease = javaCompileRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remapSourcesJar(Path source, Path destination) throws IOException {
        if (source.equals(destination)) {
            throw new UnsupportedOperationException("Cannot remap in place");
        }
        Path srcPath = source;
        boolean isSrcTmp = false;
        if (!Files.isDirectory(source, new LinkOption[0])) {
            isSrcTmp = true;
            srcPath = Files.createTempDirectory("fabric-loom-src", new FileAttribute[0]);
            ZipUtils.unpackAll(source, srcPath);
        }
        if (!Files.isDirectory(destination, new LinkOption[0]) && Files.exists(destination, new LinkOption[0])) {
            Files.delete(destination);
        }
        try (FileSystemUtil.Delegate dstFs = Files.isDirectory(destination, new LinkOption[0]) ? null : FileSystemUtil.getJarFileSystem(destination, true);){
            Path dstPath = dstFs != null ? dstFs.get().getPath("/", new String[0]) : destination;
            this.doRemap(srcPath, dstPath, source);
            SourceRemapper.copyNonJavaFiles(srcPath, dstPath, LOGGER, source);
        }
        finally {
            if (isSrcTmp) {
                Files.walkFileTree(srcPath, new DeletingFileVisitor());
            }
        }
    }

    private synchronized void doRemap(Path srcPath, Path dstPath, Path source) {
        try {
            this.mercury.get().rewrite(srcPath, dstPath);
        }
        catch (Exception e) {
            LOGGER.warn("Could not remap " + source + " fully!", (Throwable)e);
        }
    }

    private MappingSet getMappings() throws IOException {
        return new TinyMappingsReader((MappingTree)this.mappingsService.getMemoryMappingTree(), this.mappingsService.getFromNamespace(), this.mappingsService.getToNamespace()).read();
    }

    private Mercury createMercury() {
        Mercury mercury = new Mercury();
        mercury.setGracefulClasspathChecks(true);
        mercury.setSourceCompatibilityFromRelease(this.javaCompileRelease);
        try {
            mercury.getProcessors().add(MercuryRemapper.create((MappingSet)this.getMappings()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read mercury mappings", e);
        }
        for (File file : this.classpath.getFiles()) {
            if (!file.exists()) continue;
            mercury.getClassPath().add(file.toPath());
        }
        return mercury;
    }
}

