/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loom.LoomGradlePlugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;

public class ModVersionParser {
    private final Project project;
    private String version = null;

    public ModVersionParser(Project project) {
        this.project = project;
    }

    public String getModVersion() {
        JsonObject jsonObject;
        if (this.version != null) {
            return this.version;
        }
        File json = this.locateModJsonFile();
        try (FileReader reader = new FileReader(json);){
            jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read fabric.mod.json file");
        }
        if (!jsonObject.has("version") || !jsonObject.get("version").isJsonPrimitive()) {
            throw new UnsupportedOperationException("Could not find valid version in the fabric.mod.json file");
        }
        this.version = jsonObject.get("version").getAsString();
        return this.version;
    }

    private File locateModJsonFile() {
        return ((SourceSet)((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main")).getResources().matching(patternFilterable -> patternFilterable.include(new String[]{"fabric.mod.json"})).getSingleFile();
    }
}

