/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.minecraft.MergedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarEnvType;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SplitMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.AbstractMappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;

public abstract class NamedMinecraftProvider<M extends MinecraftProvider>
extends AbstractMappedMinecraftProvider<M> {
    public NamedMinecraftProvider(Project project, M minecraftProvider) {
        super(project, minecraftProvider);
    }

    @Override
    public final MappingsNamespace getTargetNamespace() {
        return MappingsNamespace.NAMED;
    }

    @Override
    public AbstractMappedMinecraftProvider.MavenScope getMavenScope() {
        return AbstractMappedMinecraftProvider.MavenScope.GLOBAL;
    }

    public static final class SingleJarImpl
    extends NamedMinecraftProvider<SingleJarMinecraftProvider>
    implements MappedMinecraftProvider.SingleJar {
        private final SingleJarEnvType env;

        private SingleJarImpl(Project project, SingleJarMinecraftProvider minecraftProvider, SingleJarEnvType env) {
            super(project, minecraftProvider);
            this.env = env;
        }

        public static SingleJarImpl server(Project project, SingleJarMinecraftProvider minecraftProvider) {
            return new SingleJarImpl(project, minecraftProvider, SingleJarEnvType.SERVER);
        }

        public static SingleJarImpl client(Project project, SingleJarMinecraftProvider minecraftProvider) {
            return new SingleJarImpl(project, minecraftProvider, SingleJarEnvType.CLIENT);
        }

        @Override
        public List<AbstractMappedMinecraftProvider.RemappedJars> getRemappedJars() {
            return List.of(new AbstractMappedMinecraftProvider.RemappedJars(((SingleJarMinecraftProvider)this.minecraftProvider).getMinecraftEnvOnlyJar(), this.getEnvOnlyJar(), MappingsNamespace.OFFICIAL, new Path[0]));
        }

        @Override
        public List<String> getDependencyTargets() {
            return List.of(this.envName());
        }

        @Override
        public SingleJarEnvType env() {
            return this.env;
        }
    }

    public static final class SplitImpl
    extends NamedMinecraftProvider<SplitMinecraftProvider>
    implements MappedMinecraftProvider.Split {
        public SplitImpl(Project project, SplitMinecraftProvider minecraftProvider) {
            super(project, minecraftProvider);
        }

        @Override
        public List<AbstractMappedMinecraftProvider.RemappedJars> getRemappedJars() {
            return List.of(new AbstractMappedMinecraftProvider.RemappedJars(((SplitMinecraftProvider)this.minecraftProvider).getMinecraftCommonJar(), this.getCommonJar(), MappingsNamespace.OFFICIAL, new Path[0]), new AbstractMappedMinecraftProvider.RemappedJars(((SplitMinecraftProvider)this.minecraftProvider).getMinecraftClientOnlyJar(), this.getClientOnlyJar(), MappingsNamespace.OFFICIAL, ((SplitMinecraftProvider)this.minecraftProvider).getMinecraftCommonJar()));
        }

        @Override
        protected void configureRemapper(AbstractMappedMinecraftProvider.RemappedJars remappedJars, TinyRemapper.Builder tinyRemapperBuilder) {
            SplitImpl.configureSplitRemapper(remappedJars, tinyRemapperBuilder);
        }

        @Override
        public List<String> getDependencyTargets() {
            return List.of("clientOnly", "common");
        }
    }

    public static final class MergedImpl
    extends NamedMinecraftProvider<MergedMinecraftProvider>
    implements MappedMinecraftProvider.Merged {
        public MergedImpl(Project project, MergedMinecraftProvider minecraftProvider) {
            super(project, minecraftProvider);
        }

        @Override
        public List<AbstractMappedMinecraftProvider.RemappedJars> getRemappedJars() {
            return List.of(new AbstractMappedMinecraftProvider.RemappedJars(((MergedMinecraftProvider)this.minecraftProvider).getMergedJar(), this.getMergedJar(), MappingsNamespace.OFFICIAL, new Path[0]));
        }

        @Override
        public List<String> getDependencyTargets() {
            return List.of("merged");
        }
    }
}

