/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarEnvType;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;

public final class SingleJarMinecraftProvider
extends MinecraftProvider {
    private final Environment environment;
    private Path minecraftEnvOnlyJar;

    private SingleJarMinecraftProvider(ConfigContext configContext, Environment environment) {
        super(configContext);
        this.environment = environment;
    }

    public static SingleJarMinecraftProvider server(ConfigContext configContext) {
        return new SingleJarMinecraftProvider(configContext, new Server());
    }

    public static SingleJarMinecraftProvider client(ConfigContext configContext) {
        return new SingleJarMinecraftProvider(configContext, new Client());
    }

    @Override
    protected void initFiles() {
        super.initFiles();
        this.minecraftEnvOnlyJar = this.path("minecraft-%s-only.jar".formatted(new Object[]{this.environment.type()}));
    }

    @Override
    public List<Path> getMinecraftJars() {
        return List.of(this.minecraftEnvOnlyJar);
    }

    @Override
    public void provide() throws Exception {
        boolean requiresRefresh;
        super.provide();
        if (this.provideClient() && this.getVersionInfo().isVersionOrNewer("2012-07-25T22:00:00+00:00")) {
            this.getProject().getLogger().warn("Using `clientOnlyMinecraftJar()` is not recommended for Minecraft versions 1.3 or newer.");
        }
        boolean bl = requiresRefresh = this.getExtension().refreshDeps() || Files.notExists(this.minecraftEnvOnlyJar, new LinkOption[0]);
        if (!requiresRefresh) {
            return;
        }
        Path inputJar = this.environment.getInputJar(this);
        TinyRemapper remapper = null;
        try {
            remapper = TinyRemapper.newRemapper().build();
            Files.deleteIfExists(this.minecraftEnvOnlyJar);
            try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(this.minecraftEnvOnlyJar).build();){
                outputConsumer.addNonClassFiles(inputJar, NonClassCopyMode.FIX_META_INF, remapper);
                remapper.readInputs(new Path[]{inputJar});
                remapper.apply((BiConsumer)outputConsumer);
            }
        }
        catch (Exception e) {
            Files.deleteIfExists(this.minecraftEnvOnlyJar);
            throw new RuntimeException("Failed to process %s only jar".formatted(new Object[]{this.environment.type()}), e);
        }
        finally {
            if (remapper != null) {
                remapper.finish();
            }
        }
    }

    @Override
    protected boolean provideClient() {
        return this.environment instanceof Client;
    }

    @Override
    protected boolean provideServer() {
        return this.environment instanceof Server;
    }

    public Path getMinecraftEnvOnlyJar() {
        return this.minecraftEnvOnlyJar;
    }

    private static interface Environment {
        public SingleJarEnvType type();

        public Path getInputJar(SingleJarMinecraftProvider var1) throws Exception;
    }

    private static final class Server
    implements Environment {
        private Server() {
        }

        @Override
        public SingleJarEnvType type() {
            return SingleJarEnvType.SERVER;
        }

        @Override
        public Path getInputJar(SingleJarMinecraftProvider provider) throws Exception {
            BundleMetadata serverBundleMetadata = provider.getServerBundleMetadata();
            if (serverBundleMetadata == null) {
                return provider.getMinecraftServerJar().toPath();
            }
            provider.extractBundledServerJar();
            return provider.getMinecraftExtractedServerJar().toPath();
        }
    }

    private static final class Client
    implements Environment {
        private Client() {
        }

        @Override
        public SingleJarEnvType type() {
            return SingleJarEnvType.CLIENT;
        }

        @Override
        public Path getInputJar(SingleJarMinecraftProvider provider) throws Exception {
            return provider.getMinecraftClientJar().toPath();
        }
    }
}

